package com.digiwin.athena.dao.mongodao.assembly;

import com.digiwin.athena.bo.assembly.SolutionPlan;
import com.digiwin.athena.dto.PageReqCondition;
import com.digiwin.athena.dto.Pagination;
import com.digiwin.athena.dto.assembly.solution.SolutionPlanListDTO;
import com.digiwin.athena.dto.assembly.solution.SolutionPlanPageQo;

import java.util.Map;
import java.util.Set;

/**
 * 设计时态解决方案DAO接口
 */
public interface DSolutionMongoDao {

    /**
     * 根据ID查询解决方案
     *
     * @param objectId 对象ID
     * @return 解决方案信息
     */
    SolutionPlan selectById(String objectId);

    /**
     * 根据编码查询解决方案
     *
     * @param code 解决方案编码
     * @return 解决方案信息
     */
    SolutionPlan selectByCode(String code);

    SolutionPlan selectByName(String solutionName);

    /**
     * 新增解决方案
     *
     * @param solution 解决方案信息
     */
    void save(SolutionPlan solution);

    Integer getNextAppType();

    /**
     * 根据ID删除解决方案
     *
     * @param objectId 对象ID
     * @return 是否成功
     */
    boolean deleteById(String objectId);

    /**
     * 检查是否已存在
     *
     * @param code      编码
     * @param name      name
     * @param excludeId 排除的ID（用于更新时检查）
     * @return 是否存在
     */
    boolean existsByKey(String code, String name, String excludeId);

    Pagination<SolutionPlanListDTO> selectPage(PageReqCondition<SolutionPlanPageQo> param);

    Map<String, Set<SolutionPlanListDTO>> findListByDesignerId(Iterable<String> designerIdColl);
}
