package com.digiwin.athena.mongodb.domain.application;

import cn.hutool.http.Method;
import com.alibaba.fastjson.JSONObject;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.mapping.Document;

import java.util.List;

/**
 * 解决方案定义
 */
@Data
@Document(collection = "applicationConfig")
public class ApplicationConfig {

    @Id
    private String objectId;

    /**
     * 类型代号
     */
    private String type;

    /**
     * app类型
     */
    private Integer appType;

    /**
     * 解决方案名称
     */
    private String name;

    /**
     * 全行业/数据分析/开发工具
     * 预留字段，支持path方式，对应前端的code
     */
    private String category;

    /**
     * 对应前端配置
     */
    private JSONObject page;

    /**
     * 前置条件组，一期只支持单一条件
     */
    private List<Precondition> precondition;

    /**
     * 预设模组
     */
    private IamConfig iamConfig;

    /**
     * 创建接口回调
     */
    private List<AppCallBack> appCreateCallback;

    /**
     * 更新接口回调
     */
    private List<AppCallBack> appUpdateCallback;

    /**
     * 删除接口回调
     */
    private List<AppCallBack> appDeleteCallback;

    /**
     * 收集接口配置(应用粒度)
     */
    private List<AppCallBack> collect;

    /**
     * 编辑器配置(应用粒度)
     */
    private List<AppCallBack> compile;

    /**
     * 发版接口配置(应用粒度)
     */
    private List<AppCallBack> publish;

    /**
     * 切版接口配置(应用粒度)
     */
    private List<AppCallBack> switched;

    /**
     * 是否为热门 0:热门卡片 1:非热门卡面
     */
    private Integer popular;

    /**
     * 首页热门卡片排序
     */
    private Integer popularSort;

    /**
     * 处理类
     */
    private String extraActionBeanName;

    /**
     * 模型初始化之前需要执行的脚本确定走哪个api生成的版本
     */
    private String beforeModelCreateScriptId;

    /**
     * 扩展配置信息
     */
    private JSONObject extProperties;

    /**
     * app创建url
     */
    private AppCallBack appCreate;

    /**
     * app更新url
     */
    private AppCallBack appUpdate;

    @Data
    public static class Precondition {

        /**
         * bean名称
         */
        private String beanName;

        /**
         * 方法名可不填，默认为judge
         */
        private String method = "judge";

        /**
         * 参数 对应OM商品id
         */
        private List<String> params;
    }

    @Data
    public static class IamConfig {

        /**
         * 模组相关配置
         */
        private List<Module> module;
    }

    @Data
    public static class AppCallBack {

        @Schema(description = "api类型，例如：http，groovy")
        private String type;

        @Schema(description = "url")
        private String url;

        @Schema(description = "当type是bean时，name是bean的name")
        private String name;

        @Schema(description = "请求类型：GET/POST")
        private Method method;

        @Schema(description = "头信息，json 字符串 k-v 格式")
        private String header;

        @Schema(description = "groovy脚本Id")
        private String scriptId;

        @Schema(description = "请求脚本")
        private String requestScript;

        @Schema(description = "响应脚本")
        private String responseScript;

        @Schema(description = "请求方法名称")
        private String methodName;
    }
}
