package com.digiwin.athena.service.applicationHandler.handler;

import com.digiwin.athena.dto.PageReqCondition;
import com.digiwin.athena.dto.Pagination;
import com.digiwin.athena.dto.asset.AssetCenterInfoResDto;
import com.digiwin.athena.enums.DeleteApplicationProcessEnum;
import com.digiwin.athena.mongodb.domain.ApiInfo;
import com.digiwin.athena.mongodb.domain.application.Application;
import com.digiwin.athena.mongodb.domain.assetType.AssetType;
import com.digiwin.athena.service.asset.AssetCenter;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

@Component
@Slf4j
public class AssetDeleteHandler extends AbstractDeletionHandler {

    @Autowired
    private AssetCenter assetCenter;

    @Override
    protected void doDeleteExecute(Application application) {
        List<AssetType> assetTypes = new ArrayList<>();
        for (AssetType assetType : assetTypes) {

            PageReqCondition<String> pageReqCondition = new PageReqCondition<>();
            pageReqCondition.setPageSize(100);

            List<ApiInfo> apiInfos = new ArrayList<>();
            if (!CollectionUtils.isEmpty(assetType.getOpenApiList())){
                apiInfos.addAll(assetType.getOpenApiList());
            }

            if (!CollectionUtils.isEmpty(assetType.getApiList())){
                apiInfos.addAll(assetType.getApiList());
            }

            apiInfos = apiInfos.stream().filter(a->a.getKey().equals(ApiInfo.KEY_APP_DELETE)).collect(Collectors.toList());

            if (apiInfos.isEmpty()){
                return;
            }

            Pagination<AssetCenterInfoResDto> pagination = assetCenter.appAssetList(pageReqCondition, List.of(application.getCode()), List.of(assetType.getType()));
            while(!CollectionUtils.isEmpty(pagination.getData())){
                List<AssetCenterInfoResDto> data = pagination.getData();
                for (ApiInfo apiInfo : apiInfos) {

                }
            }

        }

    }

    @Override
    protected void doValidateExecute(Application application) {

    }

    @Override
    protected void doBackup(Application application) {

    }

    @Override
    DeleteApplicationProcessEnum getDeleteType() {
        return DeleteApplicationProcessEnum.DELETE_ASSET;
    }
}
