package com.digiwin.athena.bo.assembly;

import cn.hutool.core.util.StrUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface IVersion {
    int DEFAULT_VERSION_SORT = Integer.MAX_VALUE;
    Logger log = LoggerFactory.getLogger(IVersion.class);

    /**
     *
     * @return 版本号 格式：x.x
     */
    String getVersion();

    /**
     * 版本排序，version根据`.`分割，{第一部分}*1000+{第二部分}
     */
    default Integer getVersionSort() {
        return parseVersionSort();
    }

    default Integer parseVersionSort() {
        if (StrUtil.isBlank(getVersion())) {
            return DEFAULT_VERSION_SORT;
        }

        String[] versionParts = getVersion().split("\\.");
        try {
            return Integer.parseInt(versionParts[0]) * 1000 + Integer.parseInt(versionParts[1]);
        } catch (Exception e) {
            log.error("设计器版本号解析异常！version:{},msg:{}", getVersion(), e.getMessage());
        }

        return DEFAULT_VERSION_SORT;
    }
}
