package com.digiwin.athena.bo.assembly;

import com.digiwin.athena.dto.TenantInfo;
import com.digiwin.athena.mysql.domain.user.UserPO;
import com.digiwin.athena.utils.CurThreadInfoUtils;
import com.digiwin.athena.utils.user.UserHelper;
import lombok.Data;

/**
 * 运行时变量响应DTO
 */
@Data
public class RuntimeVariable {

    /**
     * 系统变量
     */
    private Sys sys;

    public static RuntimeVariable capture() {
        RuntimeVariable runtimeVariable = new RuntimeVariable();
        runtimeVariable.setSys(Sys.capture());

        return runtimeVariable;
    }

    @Data
    public static class Sys {
        private User user;
        private Env env;

        public static Sys capture() {
            Sys sys = new RuntimeVariable.Sys();

            sys.setEnv(Env.capture());
            sys.setUser(User.capture());

            return sys;
        }
    }

    @Data
    public static class User {
        private String id;
        private String name;
        private String token;
        private String tenantId;
        private String tenantSid;
        private String tenantName;
        private String teamId;

        public static User capture() {
            UserPO userPo = UserHelper.getCurrentUser();
            // 获取租户信息
            TenantInfo tenantInfo = CurThreadInfoUtils.getCurTokenTenant();

            // 构建sys.userPo
            RuntimeVariable.User userVar = new RuntimeVariable.User();
//            userVar.setId(StrUtil.toStringOrNull(userPo.getId()));
            userVar.setName(userPo.getName());
            userVar.setToken(UserHelper.getCurrentIamToken());

            if (tenantInfo != null) {
                userVar.setTenantId(tenantInfo.getTenantId());
                userVar.setTenantSid(tenantInfo.getTenantSid());
                userVar.setTenantName(tenantInfo.getTenantName());
//                userVar.setTeamId(tenantInfo.getTeamId());
            }

            return userVar;
        }
    }

    @Data
    public static class Env {
        private String branchKey;
        private String locale;
        private String curApplication;
        private String tenantProcessId;
        private String individualCaseAppCode;
        private String platformSource;
        private String routerKey;
        private String templateId;

        public static Env capture() {
            Env env = new Env();

            env.setBranchKey(CurThreadInfoUtils.getBranchKey());
            env.setLocale(CurThreadInfoUtils.getLocale());
            env.setCurApplication(CurThreadInfoUtils.getCurApplication());
            env.setIndividualCaseAppCode(CurThreadInfoUtils.getIndividualCaseAppCode());
            env.setPlatformSource(CurThreadInfoUtils.getPlatformSource());
            env.setRouterKey(CurThreadInfoUtils.getRouterKey());
            env.setTemplateId(CurThreadInfoUtils.getTemplateId());
//            env.setTenantProcessId(CurThreadInfoUtils.getTenantProcessId());

            return env;
        }

    }
}
