package com.digiwin.athena.dao.mongodao.assembly;

import com.digiwin.athena.bo.assembly.SolutionPlan;
import com.digiwin.athena.dto.PageReqCondition;
import com.digiwin.athena.dto.Pagination;
import com.digiwin.athena.dto.assembly.solution.RSolutionPlanPageQo;
import com.digiwin.athena.dto.assembly.solution.SolutionPlanListDTO;

import java.util.Collection;
import java.util.List;

/**
 * 运行时态解决方案DAO接口
 */
public interface RSolutionMongoDao {

    /**
     * 根据ID查询解决方案
     *
     * @param objectId 对象ID
     * @return 解决方案信息
     */
    SolutionPlan selectById(String objectId);

    /**
     * 分页查询状态为online的解决方案列表
     *
     * @param pageReqCondition 分页查询条件
     * @return 分页结果
     */
    Pagination<SolutionPlanListDTO> selectOnlineSolutionPage(PageReqCondition<RSolutionPlanPageQo> pageReqCondition);

    /**
     * 新增解决方案
     *
     * @param solution 解决方案信息
     * @return 解决方案信息
     */
    void save(SolutionPlan solution);

    /**
     * 根据ID删除解决方案
     *
     * @param objectId 对象ID
     * @return 是否成功
     */
    boolean deleteById(String objectId);

    List<SolutionPlanListDTO> selectByAppType(Collection<Integer> appType);
}
