package com.digiwin.athena.mongodb.domain.assembly;

import cn.hutool.core.bean.BeanUtil;
import com.digiwin.athena.bo.assembly.SolutionPlan;
import com.digiwin.athena.dto.action.MultiLanguageDTO;
import com.digiwin.athena.dto.assembly.solution.SolutionPlanDetailDTO;
import com.digiwin.athena.mongodb.domain.BaseMongoEntity;
import lombok.Data;
import lombok.experimental.FieldNameConstants;
import org.bson.types.ObjectId;
import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.mapping.Document;
import org.springframework.data.mongodb.core.mapping.FieldName;

import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;

/**
 * 可组装解决方案配置
 */
@Data
@FieldNameConstants
@Document(collection = "applicationConfig")
public class AssemblyApplicationConfigEntity implements BaseMongoEntity<String> {
    @Id
    private String id;              // 主键ID

    private String type;              // 解决方案编码，全局唯一
    private String name;              // 解决方案名称
    private String version;                   // 版本号 service层暂时写死1.0
    private Integer versionSort;                  // 版本排序 version根据`.`分割，{第一部分}*1000+{第二部分}
    private String description;               // 描述
    private String assemblyType;              // 组装方式：dynamic(可组装)/static(不可组装)，枚举值
    private String status;             // 解决方案状态：Draft(草稿)/Online(已上架)/Offline(未上架) 枚举值
    private String owner;                     // 归属方
    private Integer appType;                  // 应用类型，新增时自动分配

    private List<SolutionPlanDetailDTO.DesignerBaseInfoDTO> designerList;  // 关联设计器列表
    private Map<String, Object> canvas;              // 布局配置
    private String layoutMode;                  // 布局方式
    private SolutionPlanDetailDTO.SsoConfigDTO ssoConfig;              // SSO配置(不可组装页面配置)

    // 扩展配置字段
    private List<SolutionPlanDetailDTO.AppCallBackDTO> appCreateCallback;        // 应用创建回调
    private List<SolutionPlanDetailDTO.AppCallBackDTO> appUpdateCallback;        // 应用更新回调
    private List<SolutionPlanDetailDTO.AppCallBackDTO> compile;          // 编译回调
    private List<SolutionPlanDetailDTO.AppCallBackDTO> publish;          // 发布回调

    private Boolean isStdPublish;  // true走标准发布，对应的应用类型会在运维中心体现

    private Map<String, MultiLanguageDTO<String>> lang;              // 多语言配置

    /**
     * @see SolutionPlan#getMergeJson
     */
    private Map<String, Object> mergeJson;

    private LocalDateTime publishTime;         // 发布时间
    private String publishBy;                  // 发布人
    private LocalDateTime createTime;           // 创建时间
    private LocalDateTime editTime;             // 更新时间
    private String createBy;                  // 创建人
    private String editBy;                  // 更新人


    public void clearMergeJsonMap() {
        mergeJson.remove(AssemblyApplicationConfigEntity.Fields.id);
        mergeJson.remove(AssemblyApplicationConfigEntity.Fields.type);
        mergeJson.remove(AssemblyApplicationConfigEntity.Fields.name);
        mergeJson.remove(AssemblyApplicationConfigEntity.Fields.status);

        mergeJson.remove(AssemblyApplicationConfigEntity.Fields.publishTime);
        mergeJson.remove(AssemblyApplicationConfigEntity.Fields.publishBy);

        mergeJson.remove(AssemblyApplicationConfigEntity.Fields.createTime);
        mergeJson.remove(AssemblyApplicationConfigEntity.Fields.editTime);
        mergeJson.remove(AssemblyApplicationConfigEntity.Fields.createBy);
        mergeJson.remove(AssemblyApplicationConfigEntity.Fields.editBy);
    }

    public Map<String, Object> mergeToEntityMap() {
        Map<String, Object> entityMap = BeanUtil.beanToMap(this);

        clearMergeJsonMap();
        entityMap.putAll(mergeJson);
        entityMap.remove(AssemblyApplicationConfigEntity.Fields.id);
        if (getId() != null) {
            entityMap.put(FieldName.ID.name(), new ObjectId(getId()));
        }

        return entityMap;
    }

}
