package com.digiwin.athena.service.applicationHandler.handler;

import com.digiwin.athena.actuator.HttpActuator;
import com.digiwin.athena.actuator.HttpExecuteConfig;
import com.digiwin.athena.actuator.ReqPlaceholder;
import com.digiwin.athena.dto.PageReqCondition;
import com.digiwin.athena.dto.Pagination;
import com.digiwin.athena.dto.ResultDto;
import com.digiwin.athena.dto.asset.AssetCenterInfoResDto;
import com.digiwin.athena.enums.DeleteApplicationProcessEnum;
import com.digiwin.athena.mongodb.domain.ApiInfo;
import com.digiwin.athena.mongodb.domain.ExecuteConfig;
import com.digiwin.athena.mongodb.domain.application.Application;
import com.digiwin.athena.mongodb.domain.assetType.AssetType;
import com.digiwin.athena.service.asset.AssetCenter;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@Component
@Slf4j
@RequiredArgsConstructor
public class AssetDeleteHandler extends AbstractDeletionHandler {

    private AssetCenter assetCenter;
    private HttpActuator httpActuator;

    @Override
    protected void doDeleteExecute(Application application) {
        List<AssetType> assetTypes = new ArrayList<>();
        ObjectMapper mapper = new ObjectMapper();
        for (AssetType assetType : assetTypes) {

            List<ApiInfo> apiInfos = Stream.of(assetType.getOpenApiList(), assetType.getApiList())
                    .filter(Objects::nonNull)
                    .flatMap(List::stream)
                    .filter(a -> a.getKey().equals(ApiInfo.KEY_APP_DELETE) && a.getExecuteConfig() != null)
                    .collect(Collectors.toList());

            if (apiInfos.isEmpty()){
                return;
            }

            PageReqCondition<String> pageReqCondition = new PageReqCondition<>();
            pageReqCondition.setPageSize(100);
            Pagination<AssetCenterInfoResDto> pagination = assetCenter.appAssetList(pageReqCondition, List.of(application.getCode()), List.of(assetType.getType()));
            List<AssetCenterInfoResDto> datas = pagination.getData();

            while(!CollectionUtils.isEmpty(datas)){
                for (ApiInfo apiInfo : apiInfos) {
                    ExecuteConfig executeConfig = apiInfo.getExecuteConfig();
                    HttpExecuteConfig httpExecuteConfig = executeConfig.createHttpExecuteConfig();

                    for (AssetCenterInfoResDto data : datas) {
                        Map<String, Object> requestParams = mapper.convertValue(data, new TypeReference<>() {
                        });

                        ResultDto res = (ResultDto) httpActuator.execute(httpExecuteConfig, requestParams, ReqPlaceholder.createParams(null), ResultDto.class);
                        if (res.getCode() != 0) {
                            try {
                                log.error("删除资产数据异常:"+mapper.writeValueAsString(res));
                            } catch (JsonProcessingException e) {
                                throw new RuntimeException(e);
                            }
                            throw new RuntimeException("删除资产数据异常");
                        }
                    }
                }
            }

        }

    }

    @Override
    protected void doValidateExecute(Application application) {

    }

    @Override
    protected void doBackup(Application application) {

    }

    @Override
    DeleteApplicationProcessEnum getDeleteType() {
        return DeleteApplicationProcessEnum.DELETE_ASSET;
    }
}
