package com.digiwin.athena.service.asset;

import com.digiwin.athena.dto.PageReqCondition;
import com.digiwin.athena.dto.Pagination;
import com.digiwin.athena.dto.asset.AssetBatchOpenReqDto;
import com.digiwin.athena.dto.asset.AssetCenterInfoResDto;
import com.digiwin.athena.dto.asset.AssetDetailResDto;
import com.digiwin.athena.dto.asset.AssetInfoDto;
import com.digiwin.athena.dto.asset.AssetInfoResDto;
import com.digiwin.athena.dto.asset.AssetOpenReqDto;
import com.digiwin.athena.dto.asset.AssetRelationAppInfoResDto;
import com.digiwin.athena.dto.asset.AssetRelationInfoDto;
import com.digiwin.athena.dto.asset.DeleteAssetReqDto;
import com.digiwin.athena.dto.asset.DependentAssetResDto;
import com.digiwin.athena.dto.asset.DesignerAssetListReqDto;
import com.digiwin.athena.dto.asset.CreateAssetReqDto;
import com.digiwin.athena.dto.asset.DepAssetResDto;
import com.digiwin.athena.dto.asset.UseAssetListReqDto;
import com.digiwin.athena.mongodb.domain.application.Asset;
import com.digiwin.athena.mongodb.domain.application.AssetDefinition;
import com.digiwin.athena.mongodb.domain.application.AssetRelation;
import java.util.List;
import java.util.Map;

public interface AssetCenter {

    /**
     * 新增保存资产
     * 如果保存的这个版本资产，是开发分支，并且是生效的，这个版本的资产就会是生效的
     * @return 资产id
     */
    public String saveDTDAsset(AssetInfoDto assetInfoDto);

    /**
     * @description: 工作台保存资产
     * @param
     * @return 
     * @author: sunyfa
     */
    String saveWorkbenchAsset(AssetInfoDto assetInfoDto);

    /**
     * 添加绑定关系
     * @param assetRelationInfoDto
     */
    void bindRelation(AssetRelationInfoDto assetRelationInfoDto);

    /**
     * 根据应用code 版本 分支 查询所有版本资产
     * @param application 不能为空
     * @param adpVersion 可以为空
     * @param branch 可以为空
     * @return
     */
    List<Asset> getAssetList( String application,  String adpVersion, String branch);

    /**
     * 获取引用关系的生效资产
     * @param application
     * @param adpVersion
     * @param branch
     * @return
     */
    List<Asset> getRefDTDAssetList( String application,  String adpVersion, String branch);


    /**
     * 删除指定应用对指定资产的引用关系
     * @param assetIds
     * @param adpVersion
     * @param branch
     * @param application
     * @return
     */
    Boolean removeRefRelation(List<String> assetIds, String adpVersion, String branch, String application);

    /**
     * 获取指定应用分支下指定版本的 引用资产的关系
     * @return
     */
    List<AssetRelation> getBindDTDRefRelation(AssetRelationInfoDto assetRelationInfoDto);

    /**
     * 断开这个应用分支版本下的所有引用关系
     * @param assetRelationInfoDto
     * @return
     */
    Boolean removeReferenceRel(AssetRelationInfoDto assetRelationInfoDto);

    /**
     * 查询生效的资产
     * @param assetId
     * @return
     */
    Asset getEffectAsset(String assetId);

    /**
     * 查询生效的资产
     * @param assetIds
     * @return
     */
    List<Asset> getEffectAssets(List<String> assetIds);

    /**
     * 查询资产的生效版本
     * @param assetIds
     * @return
     */
    Map<String,Asset> getEffectAssetVersion(List<String> assetIds);

    /**
     * 获取历史版本的资产数据
     * @param assetId 资产id
     * @param sourceBranch 来源分支数据
     * @param adpVersion 来源的哪个版本
     * @return
     */
    Asset getHistoryAsset(String assetId, String sourceBranch, String adpVersion);

    /**
     * 更新上架资产
     * @param assetInfoDto
     * @return
     */
    Boolean availableAsset(AssetInfoDto assetInfoDto);

    /**
     * 更新资产定义
     * @param assetOpenReqDto
     * @return
     */
    Boolean updateAssetDefinition(AssetOpenReqDto assetOpenReqDto);

    /**
     * 上架
     * @param assetOpenReqDtoList 上架资产信息
     * @return
     */
    Boolean availableAsset(AssetOpenReqDto assetOpenReqDtoList);

    Boolean batchAvailableAsset(AssetBatchOpenReqDto assetBatchOpenReqDto);

    /**
     * 下架
     * @param code 业务code
     * @param application
     * @return
     */
    Boolean removedAsset(String code, String application);

    /**
     * 下架
     * @param assetId 资产id
     * @return
     */
    Boolean removedAsset(String assetId);

    /**
     * 删除指定版本的资产数据，需要在删除业务数据之前调用该方法
     * @param assetInfoDto
     */
    void deleteVersionAsset(AssetInfoDto assetInfoDto);

    /**
     * 删除指定的资产数据，需要在删除业务数据之前调用该方法
     * @param asset
     */
    void deleteAsset(Asset asset);

    /**
     * 根据 业务code 查询资产定义表中的冗余业务数据
     * @param code
     * @return
     */
    String getAssetDefinitionBusinessData(String code,String application);
    /**
     * 获取资产中心列表
     * @param pageReqCondition
     * @return
     */
    Pagination<AssetCenterInfoResDto> getAssetCenterList(PageReqCondition<String> pageReqCondition,String type);

    /**
     * 获取指定资产的基础详情信息
     * @param assetId
     * @return
     */
    AssetDetailResDto getAsset(String assetId);

    /**
     * 获取指定资产的引用关系
     * @param assetId
     * @return
     */
    List<AssetRelationAppInfoResDto> getAssetRefRelation(String assetId,Boolean isAssetCenter);

    /**
     * 获取当前这个应用引用异常数量，和开发资产的异常数量
     * 引用异常：被引用方的资产没有生效版本
     * 开发资产异常：这个资产下面没有一个版本
     * @param appCode
     * @return
     */
    Integer assetErrorCount(String appCode);

    Pagination<AssetCenterInfoResDto> appAssetList(PageReqCondition<String> pageReqCondition, List<String> appCode, List<String> types);

    /**
     * 资产初始化
     * @param appCode
     */
    void assetInit(String appCode, String type);

    /**
     * 分页查询依赖资产信息
     *
     * @param pageReqCondition
     * @param appCode
     * @param type
     * @return
     */
    Pagination<DependentAssetResDto> getDependAssetInfoList(PageReqCondition<String> pageReqCondition, String appCode, String type);



    List<AssetInfoResDto> assetVersionList(String assetId);

    /**
     * 获取同租户的下的可用资产
     * @param pageReqCondition
     * @return
     */
    Pagination<AssetDetailResDto> getSameTenantDtdAsset(PageReqCondition<String> pageReqCondition);

    /**
     * 获取其他租户共享的可用资产
     * @param pageReqCondition
     * @return
     */
    Pagination<AssetDetailResDto> getPlatformDtdAsset(PageReqCondition<String> pageReqCondition);



    /**
     * 下架资产开发范围的指定租户
     * @param assetId
     * @return
     */
    Boolean removedAssetOpenTenant(String assetId);

    /**
     * 应用多分支拷贝，需要拷贝资产
     * @param application
     * @param fromBranch
     * @param toBranch
     */
    void copyAppRef(String application, String fromBranch, String toBranch);

    /**
     * 创建新的多版本，需要复制老版本的引用关系
     * @param oldVersion
     * @param newVersion
     * @param branch
     */
    void copyRelationMultipleVersions(String oldVersion, String newVersion, String branch,String appCode);

    /**
     * 删除指定版本的引用关系
     * @param version
     * @param branch
     * @param appCode
     */
    void removeRelationMultipleVersions(String version, String branch, String appCode);

    /**
     * 批量更新资产数据
     * @param assetIds
     * @return
     */
    Boolean batchSyncAsset(List<String> assetIds);

    AssetDefinition findAssetDefinition(String assetId);

    void save(AssetDefinition assetDefinition);

    void draftDtdAllVersion(String application);


    /**
     * 应用内查询使用资产列表
     * @param pageReqCondition
     * @return
     */
    Pagination<AssetCenterInfoResDto> appUseAssetList(PageReqCondition<UseAssetListReqDto> pageReqCondition);

    /**
     * 用户在画布上解绑关系
     * @param taskCode
     * @param appCode
     */
    void unbindingRelationship(String taskCodes,String type, String appCode);

    /**
     * 查询资产的可复制版本
     * @param assetId
     * @return
     */
    List<AssetInfoResDto> assetCanCopyVersionList(String assetId);

    /**
     * 根据业务code查询资产信息
     * @param code
     * @param type
     * @return
     */
    AssetCenterInfoResDto getAssetDefinitionInfo(String code, String type);

    /**
     * 查询指定资产的所有版本
     * @param assetId
     * @return
     */
    Map<String,Asset> getAssetAllVersion(String assetId);

    /**
     * 设计内创建资产
     * @param createAssetReqDto
     * @return
     */
    AssetDetailResDto saveAsset(CreateAssetReqDto createAssetReqDto, com.digiwin.athena.dto.TenantInfo tenantInfo);

    void deleteAsset(DeleteAssetReqDto deleteAssetReqDto);

    Pagination<AssetDetailResDto> designerAssetList(PageReqCondition<DesignerAssetListReqDto> pageReqCondition);

    List<DepAssetResDto> getDepAssets(String objId);
}
