/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.service.assembly.impl;

import com.digiwin.athena.dao.mongodao.assembly.ApplicationDataMongoDao;
import com.digiwin.athena.dto.assembly.application.ApplicationDataRespDTO;
import com.digiwin.athena.dto.assembly.application.ApplicationDataSaveDTO;
import com.digiwin.athena.mongodb.domain.assembly.ApplicationData;
import com.digiwin.athena.service.assembly.ApplicationDataService;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ApplicationDataServiceImpl
implements ApplicationDataService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApplicationDataServiceImpl.class);
    private final ApplicationDataMongoDao applicationDataMongoDao;

    @Override
    @Transactional(rollbackFor={Throwable.class})
    public void save(ApplicationDataSaveDTO saveDTO) {
        ApplicationData applicationData;
        log.info("\u4fdd\u5b58\u5e94\u7528\u6570\u636e\uff0cappCode: {}", (Object)saveDTO.getAppCode());
        ApplicationData existing = this.applicationDataMongoDao.selectByAppCode(saveDTO.getAppCode());
        if (existing != null) {
            existing.setData(saveDTO.getData());
            applicationData = existing;
        } else {
            applicationData = new ApplicationData();
            applicationData.setAppCode(saveDTO.getAppCode());
            applicationData.setData(saveDTO.getData());
        }
        this.applicationDataMongoDao.save(applicationData);
        log.info("\u5e94\u7528\u6570\u636e\u4fdd\u5b58\u6210\u529f\uff0cappCode: {}", (Object)saveDTO.getAppCode());
    }

    @Override
    public ApplicationDataRespDTO getByAppCode(String appCode) {
        log.debug("\u67e5\u8be2\u5e94\u7528\u6570\u636e\uff0cappCode: {}", (Object)appCode);
        ApplicationData applicationData = this.applicationDataMongoDao.selectByAppCode(appCode);
        if (applicationData == null) {
            return null;
        }
        ApplicationDataRespDTO respDTO = new ApplicationDataRespDTO();
        respDTO.setData(applicationData.getData());
        return respDTO;
    }

    @Generated
    public ApplicationDataServiceImpl(ApplicationDataMongoDao applicationDataMongoDao) {
        this.applicationDataMongoDao = applicationDataMongoDao;
    }
}

