/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.bo.assembly;

import cn.hutool.core.util.StrUtil;
import com.digiwin.athena.base.BusinessException;
import com.digiwin.athena.bo.assembly.IVersion;
import com.digiwin.athena.constants.AssemblyConstants;
import com.digiwin.athena.constants.enums.assembly.OnlineState;
import com.digiwin.athena.dto.action.MultiLanguageDTO;
import com.digiwin.athena.dto.assembly.designer.DesignerDetailDTO;
import com.digiwin.athena.dto.assembly.solution.SolutionPlanBaseDTO;
import com.digiwin.athena.mongodb.domain.PublishAble;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Designer
implements PublishAble,
IVersion {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Designer.class);
    private String id;
    private String type;
    private String owner;
    private String name;
    private String version = "1.0";
    private Integer versionSort;
    private String status;
    private String description;
    private DesignerDetailDTO.RelatedAssetTypeDTO relatedAssetType;
    private List<SolutionPlanBaseDTO> relatedSolutionPlan;
    private List<DesignerDetailDTO.ApiExecInfoDTO> apiList;
    private String integrationType;
    private DesignerDetailDTO.IntegrationConfigDTO integrationConfig;
    private Map<String, MultiLanguageDTO<String>> lang;
    private Date publishTime;
    private String publishBy;
    private LocalDateTime createTime;
    private LocalDateTime editTime;
    private String createBy;
    private String editBy;

    public void overwriteUnmodifiable(Designer updated) {
        if (!OnlineState.Draft.getCode().equals(this.status)) {
            updated.setName(this.getName());
            updated.setType(this.getType());
        }
        updated.setStatus(this.getStatus());
        updated.setCreateBy(this.getCreateBy());
        updated.setCreateTime(this.getCreateTime());
        updated.setPublishBy(this.getPublishBy());
        updated.setPublishTime(this.getPublishTime());
    }

    public void prepareNew() {
        this.setStatus(OnlineState.Draft.getCode());
        this.setPublishTime(null);
        this.setPublishBy(null);
    }

    public void checkUpdate() {
        if (!OnlineState.Draft.getCode().equals(this.getStatus())) {
            throw new BusinessException(Integer.valueOf(30001), "\u8bbe\u8ba1\u5668\u72b6\u6001\u4e0d\u4e3a\u8349\u7a3f\uff01", new Object[]{this.getName(), this.getStatus()});
        }
    }

    public void checkDelete() {
        if (!OnlineState.Draft.getCode().equals(this.getStatus())) {
            throw new BusinessException(Integer.valueOf(30001), "\u8bbe\u8ba1\u5668\u72b6\u6001\u4e0d\u4e3a\u8349\u7a3f\uff01", new Object[]{this.getName(), this.getStatus()});
        }
    }

    public void validateTypeFormat() {
        if (StrUtil.isBlank((CharSequence)this.type)) {
            throw new BusinessException(Integer.valueOf(30002), "\u8bbe\u8ba1\u5668\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (!AssemblyConstants.TYPE_PATTERN.matcher(this.type).matches()) {
            throw new BusinessException(Integer.valueOf(30002), StrUtil.format((CharSequence)"\u8bbe\u8ba1\u5668\u7f16\u7801\u683c\u5f0f\u4e0d\u6b63\u786e\uff01{}\uff0c\u5f53\u524d\u7f16\u7801: {}", (Object[])new Object[]{"\u53ea\u80fd\u5927\u5c0f\u5199\u5b57\u6bcd\u3001\u6570\u5b57\u548c\u4e0b\u5212\u7ebf", this.type}));
        }
    }

    @Generated
    public Designer() {
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public String getOwner() {
        return this.owner;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Override
    @Generated
    public String getVersion() {
        return this.version;
    }

    @Override
    @Generated
    public String getStatus() {
        return this.status;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public DesignerDetailDTO.RelatedAssetTypeDTO getRelatedAssetType() {
        return this.relatedAssetType;
    }

    @Generated
    public List<SolutionPlanBaseDTO> getRelatedSolutionPlan() {
        return this.relatedSolutionPlan;
    }

    @Generated
    public List<DesignerDetailDTO.ApiExecInfoDTO> getApiList() {
        return this.apiList;
    }

    @Generated
    public String getIntegrationType() {
        return this.integrationType;
    }

    @Generated
    public DesignerDetailDTO.IntegrationConfigDTO getIntegrationConfig() {
        return this.integrationConfig;
    }

    @Generated
    public Map<String, MultiLanguageDTO<String>> getLang() {
        return this.lang;
    }

    @Override
    @Generated
    public Date getPublishTime() {
        return this.publishTime;
    }

    @Generated
    public String getPublishBy() {
        return this.publishBy;
    }

    @Generated
    public LocalDateTime getCreateTime() {
        return this.createTime;
    }

    @Generated
    public LocalDateTime getEditTime() {
        return this.editTime;
    }

    @Generated
    public String getCreateBy() {
        return this.createBy;
    }

    @Generated
    public String getEditBy() {
        return this.editBy;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setType(String type) {
        this.type = type;
    }

    @Generated
    public void setOwner(String owner) {
        this.owner = owner;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setVersion(String version) {
        this.version = version;
    }

    @Generated
    public void setVersionSort(Integer versionSort) {
        this.versionSort = versionSort;
    }

    @Override
    @Generated
    public void setStatus(String status) {
        this.status = status;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setRelatedAssetType(DesignerDetailDTO.RelatedAssetTypeDTO relatedAssetType) {
        this.relatedAssetType = relatedAssetType;
    }

    @Generated
    public void setRelatedSolutionPlan(List<SolutionPlanBaseDTO> relatedSolutionPlan) {
        this.relatedSolutionPlan = relatedSolutionPlan;
    }

    @Generated
    public void setApiList(List<DesignerDetailDTO.ApiExecInfoDTO> apiList) {
        this.apiList = apiList;
    }

    @Generated
    public void setIntegrationType(String integrationType) {
        this.integrationType = integrationType;
    }

    @Generated
    public void setIntegrationConfig(DesignerDetailDTO.IntegrationConfigDTO integrationConfig) {
        this.integrationConfig = integrationConfig;
    }

    @Generated
    public void setLang(Map<String, MultiLanguageDTO<String>> lang) {
        this.lang = lang;
    }

    @Override
    @Generated
    public void setPublishTime(Date publishTime) {
        this.publishTime = publishTime;
    }

    @Generated
    public void setPublishBy(String publishBy) {
        this.publishBy = publishBy;
    }

    @Generated
    public void setCreateTime(LocalDateTime createTime) {
        this.createTime = createTime;
    }

    @Generated
    public void setEditTime(LocalDateTime editTime) {
        this.editTime = editTime;
    }

    @Generated
    public void setCreateBy(String createBy) {
        this.createBy = createBy;
    }

    @Generated
    public void setEditBy(String editBy) {
        this.editBy = editBy;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Designer)) {
            return false;
        }
        Designer other = (Designer)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$versionSort = this.versionSort;
        Integer other$versionSort = other.versionSort;
        if (this$versionSort == null ? other$versionSort != null : !((Object)this$versionSort).equals(other$versionSort)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$owner = this.getOwner();
        String other$owner = other.getOwner();
        if (this$owner == null ? other$owner != null : !this$owner.equals(other$owner)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        String this$status = this.getStatus();
        String other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        DesignerDetailDTO.RelatedAssetTypeDTO this$relatedAssetType = this.getRelatedAssetType();
        DesignerDetailDTO.RelatedAssetTypeDTO other$relatedAssetType = other.getRelatedAssetType();
        if (this$relatedAssetType == null ? other$relatedAssetType != null : !((Object)this$relatedAssetType).equals(other$relatedAssetType)) {
            return false;
        }
        List<SolutionPlanBaseDTO> this$relatedSolutionPlan = this.getRelatedSolutionPlan();
        List<SolutionPlanBaseDTO> other$relatedSolutionPlan = other.getRelatedSolutionPlan();
        if (this$relatedSolutionPlan == null ? other$relatedSolutionPlan != null : !((Object)this$relatedSolutionPlan).equals(other$relatedSolutionPlan)) {
            return false;
        }
        List<DesignerDetailDTO.ApiExecInfoDTO> this$apiList = this.getApiList();
        List<DesignerDetailDTO.ApiExecInfoDTO> other$apiList = other.getApiList();
        if (this$apiList == null ? other$apiList != null : !((Object)this$apiList).equals(other$apiList)) {
            return false;
        }
        String this$integrationType = this.getIntegrationType();
        String other$integrationType = other.getIntegrationType();
        if (this$integrationType == null ? other$integrationType != null : !this$integrationType.equals(other$integrationType)) {
            return false;
        }
        DesignerDetailDTO.IntegrationConfigDTO this$integrationConfig = this.getIntegrationConfig();
        DesignerDetailDTO.IntegrationConfigDTO other$integrationConfig = other.getIntegrationConfig();
        if (this$integrationConfig == null ? other$integrationConfig != null : !((Object)this$integrationConfig).equals(other$integrationConfig)) {
            return false;
        }
        Map<String, MultiLanguageDTO<String>> this$lang = this.getLang();
        Map<String, MultiLanguageDTO<String>> other$lang = other.getLang();
        if (this$lang == null ? other$lang != null : !((Object)this$lang).equals(other$lang)) {
            return false;
        }
        Date this$publishTime = this.getPublishTime();
        Date other$publishTime = other.getPublishTime();
        if (this$publishTime == null ? other$publishTime != null : !((Object)this$publishTime).equals(other$publishTime)) {
            return false;
        }
        String this$publishBy = this.getPublishBy();
        String other$publishBy = other.getPublishBy();
        if (this$publishBy == null ? other$publishBy != null : !this$publishBy.equals(other$publishBy)) {
            return false;
        }
        LocalDateTime this$createTime = this.getCreateTime();
        LocalDateTime other$createTime = other.getCreateTime();
        if (this$createTime == null ? other$createTime != null : !((Object)this$createTime).equals(other$createTime)) {
            return false;
        }
        LocalDateTime this$editTime = this.getEditTime();
        LocalDateTime other$editTime = other.getEditTime();
        if (this$editTime == null ? other$editTime != null : !((Object)this$editTime).equals(other$editTime)) {
            return false;
        }
        String this$createBy = this.getCreateBy();
        String other$createBy = other.getCreateBy();
        if (this$createBy == null ? other$createBy != null : !this$createBy.equals(other$createBy)) {
            return false;
        }
        String this$editBy = this.getEditBy();
        String other$editBy = other.getEditBy();
        return !(this$editBy == null ? other$editBy != null : !this$editBy.equals(other$editBy));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Designer;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $versionSort = this.versionSort;
        result = result * 59 + ($versionSort == null ? 43 : ((Object)$versionSort).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $owner = this.getOwner();
        result = result * 59 + ($owner == null ? 43 : $owner.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        String $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        DesignerDetailDTO.RelatedAssetTypeDTO $relatedAssetType = this.getRelatedAssetType();
        result = result * 59 + ($relatedAssetType == null ? 43 : ((Object)$relatedAssetType).hashCode());
        List<SolutionPlanBaseDTO> $relatedSolutionPlan = this.getRelatedSolutionPlan();
        result = result * 59 + ($relatedSolutionPlan == null ? 43 : ((Object)$relatedSolutionPlan).hashCode());
        List<DesignerDetailDTO.ApiExecInfoDTO> $apiList = this.getApiList();
        result = result * 59 + ($apiList == null ? 43 : ((Object)$apiList).hashCode());
        String $integrationType = this.getIntegrationType();
        result = result * 59 + ($integrationType == null ? 43 : $integrationType.hashCode());
        DesignerDetailDTO.IntegrationConfigDTO $integrationConfig = this.getIntegrationConfig();
        result = result * 59 + ($integrationConfig == null ? 43 : ((Object)$integrationConfig).hashCode());
        Map<String, MultiLanguageDTO<String>> $lang = this.getLang();
        result = result * 59 + ($lang == null ? 43 : ((Object)$lang).hashCode());
        Date $publishTime = this.getPublishTime();
        result = result * 59 + ($publishTime == null ? 43 : ((Object)$publishTime).hashCode());
        String $publishBy = this.getPublishBy();
        result = result * 59 + ($publishBy == null ? 43 : $publishBy.hashCode());
        LocalDateTime $createTime = this.getCreateTime();
        result = result * 59 + ($createTime == null ? 43 : ((Object)$createTime).hashCode());
        LocalDateTime $editTime = this.getEditTime();
        result = result * 59 + ($editTime == null ? 43 : ((Object)$editTime).hashCode());
        String $createBy = this.getCreateBy();
        result = result * 59 + ($createBy == null ? 43 : $createBy.hashCode());
        String $editBy = this.getEditBy();
        result = result * 59 + ($editBy == null ? 43 : $editBy.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Designer(id=" + this.getId() + ", type=" + this.getType() + ", owner=" + this.getOwner() + ", name=" + this.getName() + ", version=" + this.getVersion() + ", versionSort=" + this.versionSort + ", status=" + this.getStatus() + ", description=" + this.getDescription() + ", relatedAssetType=" + String.valueOf(this.getRelatedAssetType()) + ", relatedSolutionPlan=" + String.valueOf(this.getRelatedSolutionPlan()) + ", apiList=" + String.valueOf(this.getApiList()) + ", integrationType=" + this.getIntegrationType() + ", integrationConfig=" + String.valueOf(this.getIntegrationConfig()) + ", lang=" + String.valueOf(this.getLang()) + ", publishTime=" + String.valueOf(this.getPublishTime()) + ", publishBy=" + this.getPublishBy() + ", createTime=" + String.valueOf(this.getCreateTime()) + ", editTime=" + String.valueOf(this.getEditTime()) + ", createBy=" + this.getCreateBy() + ", editBy=" + this.getEditBy() + ")";
    }
}

