package com.digiwin.athena.datacollect.consumer;

import com.digiwin.athena.datacollect.api.dto.AssetCollectApiResponse;
import com.digiwin.athena.datacollect.context.CollectContext;

import java.util.List;

/**
 * 数据消费接口
 * 用于在数据采集后立即消费数据（每页查询后调用）
 */
@FunctionalInterface
public interface CollectDataConsumer {

    /**
     * 消费采集到的数据
     *
     * @param context   采集上下文
     * @param dataItems 原始数据项列表
     * @return 成功消费的数量
     * @throws Exception 消费失败时抛出异常
     */
    int consume(CollectContext context, List<AssetCollectApiResponse.AssetDataItem> dataItems) throws Exception;
}
