package com.digiwin.athena.mongodb.domain.assembly;

import com.digiwin.athena.mongodb.domain.BaseMongoEntity;
import lombok.Data;
import lombok.experimental.FieldNameConstants;
import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.mapping.Document;

import java.time.LocalDateTime;
import java.util.Map;

/**
 * 应用数据配置
 */
@Data
@FieldNameConstants
@Document(collection = "applicationData")
public class ApplicationData implements BaseMongoEntity<String> {

    @Id
    private String id;              // 主键ID

    private String appCode;         // 应用编码

    private Map<String, Object> data;  // 解决方案数据

    private LocalDateTime createTime;   // 创建时间
    private LocalDateTime editTime;     // 更新时间
    private String createBy;            // 创建人
    private String editBy;              // 更新人
}
