/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.dao.mongodao.assembly.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import com.digiwin.athena.bo.assembly.SolutionPlan;
import com.digiwin.athena.constants.enums.assembly.AssemblyType;
import com.digiwin.athena.constants.enums.assembly.OnlineState;
import com.digiwin.athena.convertor.assembly.SolutionConvertor;
import com.digiwin.athena.dao.mongodao.assembly.DDesignerMongoDao;
import com.digiwin.athena.dao.mongodao.assembly.RSolutionMongoDao;
import com.digiwin.athena.dto.PageReqCondition;
import com.digiwin.athena.dto.Pagination;
import com.digiwin.athena.dto.assembly.solution.RSolutionPlanPageQo;
import com.digiwin.athena.dto.assembly.solution.SolutionPlanListDTO;
import com.digiwin.athena.mongodb.domain.assembly.AssemblyApplicationConfigEntity;
import com.digiwin.athena.mongodb.repository.MongoRuntimeRepositoryDecorator;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Repository;

@Repository
public class RSolutionMongoDaoImpl
implements RSolutionMongoDao {
    private static final SolutionConvertor CONVERTOR = SolutionConvertor.INSTANCE;
    private final MongoRuntimeRepositoryDecorator decorator;

    @Override
    public SolutionPlan selectById(String objectId) {
        AssemblyApplicationConfigEntity entity = (AssemblyApplicationConfigEntity)this.decorator.findById((Object)objectId, AssemblyApplicationConfigEntity.class);
        return CONVERTOR.toBO(entity);
    }

    @Override
    public Pagination<SolutionPlanListDTO> selectOnlineSolutionPage(PageReqCondition<RSolutionPlanPageQo> pageParam) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"status").is((Object)OnlineState.Online.getCode()));
        this.commonCondition(query);
        RSolutionPlanPageQo condition = (RSolutionPlanPageQo)ObjectUtil.defaultIfNull((Object)((RSolutionPlanPageQo)pageParam.getCondition()), RSolutionPlanPageQo::new);
        if (condition.getIsDynamic() != null) {
            Criteria dynamic = Criteria.where((String)"assemblyType");
            if (condition.getIsDynamic().booleanValue()) {
                dynamic.is((Object)AssemblyType.Dynamic.getCode());
            } else {
                dynamic.is((Object)AssemblyType.Static.getCode());
            }
            query.addCriteria((CriteriaDefinition)dynamic);
        }
        DDesignerMongoDao.addSearchNameOrType(query, condition.getSearchContent());
        return this.decorator.findWithPage(query, AssemblyApplicationConfigEntity.class, pageParam).convert(SolutionConvertor.INSTANCE::entityToListDTO);
    }

    @Override
    public void save(SolutionPlan solution) {
        AssemblyApplicationConfigEntity entity = CONVERTOR.toEntity(solution);
        entity.prepareSave();
        this.decorator.save((Object)entity);
        solution.setId(entity.getId());
    }

    @Override
    public boolean deleteById(String objectId) {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"id").is((Object)objectId));
        long count = this.decorator.remove(query, AssemblyApplicationConfigEntity.class);
        return count > 0L;
    }

    @Override
    public List<SolutionPlanListDTO> selectByAppType(Collection<Integer> appTypeList) {
        Query query = new Query();
        if (CollUtil.isNotEmpty(appTypeList)) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"appType").in(appTypeList));
        }
        this.commonCondition(query);
        return this.decorator.find(query, AssemblyApplicationConfigEntity.class).stream().map(CONVERTOR::entityToListDTO).collect(Collectors.toList());
    }

    protected void commonCondition(Query query) {
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"assemblyType").exists(true).ne(null));
    }

    @Generated
    public RSolutionMongoDaoImpl(MongoRuntimeRepositoryDecorator decorator) {
        this.decorator = decorator;
    }
}

