package com.digiwin.athena.dto.assembly.designer;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.digiwin.athena.constants.enums.assembly.IntegrationType;
import com.digiwin.athena.constants.enums.assembly.OnlineState;
import lombok.AccessLevel;
import lombok.Data;
import lombok.Getter;

import java.util.List;

@Data
public class DesignerPageQo {

    private String searchContent;  // 关键词搜索（支持名称、编码）

    /**
     * 状态（可选）
     *
     * @see OnlineState#getCode()
     */
    @Getter(AccessLevel.NONE)
    private String status;

    /**
     * 状态（可选）
     *
     * @see OnlineState#getCode()
     */
    private List<String> statusList;

    /**
     * 集成方式（可选）
     *
     * @see IntegrationType#getCode()
     */
    @Getter(AccessLevel.NONE)
    private String integrationType;

    /**
     * 集成方式（可选）
     *
     * @see IntegrationType#getCode()
     */
    private List<String> integrationTypeList;

    public List<String> getStatusList() {
        if (StrUtil.isNotBlank(status)) {
            return CollUtil.toList(status);
        }
        return statusList;
    }

    public List<String> getIntegrationTypeList() {
        if (StrUtil.isNotBlank(integrationType)) {
            return CollUtil.toList(integrationType);
        }
        return integrationTypeList;
    }
}
