/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.service.applicationHandler.handler;

import com.digiwin.athena.actuator.HttpActuator;
import com.digiwin.athena.actuator.HttpExecuteConfig;
import com.digiwin.athena.actuator.ReqPlaceholder;
import com.digiwin.athena.dto.PageReqCondition;
import com.digiwin.athena.dto.Pagination;
import com.digiwin.athena.dto.ResultDto;
import com.digiwin.athena.dto.asset.AssetCenterInfoResDto;
import com.digiwin.athena.enums.DeleteApplicationProcessEnum;
import com.digiwin.athena.mongodb.domain.ApiInfo;
import com.digiwin.athena.mongodb.domain.ExecuteConfig;
import com.digiwin.athena.mongodb.domain.application.Application;
import com.digiwin.athena.mongodb.domain.assetType.AssetType;
import com.digiwin.athena.service.applicationHandler.handler.AbstractDeletionHandler;
import com.digiwin.athena.service.asset.AssetCenter;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class AssetDeleteHandler
extends AbstractDeletionHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AssetDeleteHandler.class);
    private AssetCenter assetCenter;
    private HttpActuator httpActuator;

    protected void doDeleteExecute(Application application) {
        ArrayList assetTypes = new ArrayList();
        ObjectMapper mapper = new ObjectMapper();
        for (AssetType assetType : assetTypes) {
            List apiInfos = Stream.of(assetType.getOpenApiList(), assetType.getApiList()).filter(Objects::nonNull).flatMap(Collection::stream).filter(a -> a.getKey().equals("appDelete") && a.getExecuteConfig() != null).collect(Collectors.toList());
            if (apiInfos.isEmpty()) {
                return;
            }
            PageReqCondition pageReqCondition = new PageReqCondition();
            pageReqCondition.setPageSize(Integer.valueOf(100));
            Pagination<AssetCenterInfoResDto> pagination = this.assetCenter.appAssetList((PageReqCondition<String>)pageReqCondition, List.of(application.getCode()), List.of(assetType.getType()));
            List datas = pagination.getData();
            while (!CollectionUtils.isEmpty((Collection)datas)) {
                for (ApiInfo apiInfo : apiInfos) {
                    ExecuteConfig executeConfig = apiInfo.getExecuteConfig();
                    HttpExecuteConfig httpExecuteConfig = executeConfig.createHttpExecuteConfig();
                    for (AssetCenterInfoResDto data : datas) {
                        Map requestParams = (Map)mapper.convertValue((Object)data, (TypeReference)new TypeReference<Map<String, Object>>(){});
                        ResultDto res = (ResultDto)this.httpActuator.execute(httpExecuteConfig, (Object)requestParams, ReqPlaceholder.createParams(null), ResultDto.class);
                        if (res.getCode() == 0) continue;
                        try {
                            log.error("\u5220\u9664\u8d44\u4ea7\u6570\u636e\u5f02\u5e38:" + mapper.writeValueAsString((Object)res));
                        }
                        catch (JsonProcessingException e) {
                            throw new RuntimeException(e);
                        }
                        throw new RuntimeException("\u5220\u9664\u8d44\u4ea7\u6570\u636e\u5f02\u5e38");
                    }
                }
            }
        }
    }

    protected void doValidateExecute(Application application) {
    }

    protected void doBackup(Application application) {
    }

    DeleteApplicationProcessEnum getDeleteType() {
        return DeleteApplicationProcessEnum.DELETE_ASSET;
    }

    @Generated
    public AssetDeleteHandler() {
    }
}

