package com.digiwin.athena.datacollect.context;

import com.digiwin.athena.datacollect.api.dto.AssetCollectApiRequest;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import java.util.Map;

/**
 * HTTP脚本执行上下文
 * 扩展基础上下文，添加HTTP相关的请求和响应信息
 */
@Getter
@Setter
@ToString
@EqualsAndHashCode(callSuper = true)
public class HttpScriptContext extends BaseScriptContext {

    /**
     * 请求URL
     */
    private String url;

    /**
     * 请求体
     */
    private AssetCollectApiRequest requestBody;

    /**
     * 请求头
     */
    private Map<String, Object> requestHeader;

    /**
     * 响应体
     */
    private Object responseBody;

    /**
     * 响应头
     */
    private Map<String, String> responseHeader;

    public HttpScriptContext(CollectContext collectContext) {
        super(collectContext);
    }
}
