package com.digiwin.athena.datacollect.api.dto;

import lombok.Data;

/**
 * 资产实例数据采集API请求参数
 * 对应平台标准HTTP接口规范
 */
@Data
public class AssetCollectApiRequest {

    /**
     * 资产类型
     */
    private String assetType;

    /**
     * 开始时间
     */
    private String startTime;

    /**
     * 结束时间
     */
    private String endTime;

    /**
     * 分页参数 - 页码
     */
    private Integer pageNo;

    /**
     * 分页参数 - 每页大小
     */
    private Integer pageSize;

    /**
     * 指定数据变更的类型
     * 可选: insert/update/delete/upsert
     */
    private String op;
}
