package com.digiwin.athena.datacollect.model;

import lombok.Data;

import java.time.LocalDateTime;

/**
 * 任务执行业务数据
 * 记录本次任务执行的业务信息
 */
@Data
public class JobBizData {

    /**
     * 资产类型ID（AssetType的objId）
     */
    private String assetTypeId;

    /**
     * 资产类型（AssetType的type字段）
     */
    private String assetType;

    /**
     * 资产类型名称
     */
    private String assetTypeName;

    /**
     * 资产类型状态（online/offline/draft）
     */
    private String status;

    /**
     * 配置更新时间
     * 用于下次执行时比对配置是否变更
     */
    private LocalDateTime configUpdateTime;

    /**
     * 采集到的总记录数
     */
    private Integer totalCount;

    /**
     * 成功消费的记录数
     */
    private Integer consumedCount;

    /**
     * 查询的页数
     */
    private Integer totalPages;

    /**
     * 执行的步数（步进式查询）
     */
    private Integer totalSteps;
}
