package com.digiwin.athena.dto.asset;

import com.digiwin.athena.domain.pagedesign.TenantInfo;
import com.digiwin.athena.dto.action.MultiLanguageDTO;
import com.digiwin.athena.mongodb.domain.application.Asset;
import com.digiwin.athena.mongodb.domain.application.AssetDefinition;
import com.digiwin.athena.mongodb.domain.application.AssetPermission;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import org.springframework.beans.BeanUtils;
import org.springframework.util.StringUtils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Data
public class AssetDetailResDto extends AssetCenterInfoResDto{

    @Schema(description = "可复制版本")
    private List<String> copyableItems = new ArrayList<>();


    @Schema(description = "指定开发的租户id|openRange=tenant时")
    private List<TenantInfo> tenantInfos = new ArrayList<>();

    private String businessData;

    private Asset.ManageContext manageContext = new Asset.ManageContext();
    private Asset.ShowField showFields = new Asset.ShowField();

    public static AssetDetailResDto create(Asset asset){
        AssetDetailResDto assetDetailResDto = new AssetDetailResDto();
        BeanUtils.copyProperties(asset,assetDetailResDto);
        return assetDetailResDto;
    }

    public static AssetDetailResDto create(AssetDefinition assetDefinition){
        AssetDetailResDto assetDetailResDto = new AssetDetailResDto();
        BeanUtils.copyProperties(assetDefinition,assetDetailResDto);

        Map<String, MultiLanguageDTO> lang = assetDetailResDto.getLang();
        if (lang == null){
            lang = new HashMap<>();
            assetDetailResDto.setLang(lang);
        }
        MultiLanguageDTO<String> assetNameLang = lang.get("assetName");
        if (assetNameLang == null){
            assetNameLang = new MultiLanguageDTO<>();
            lang.put("assetName",assetNameLang);
        }
        if (!StringUtils.hasLength(assetNameLang.getZh_CN())){
            assetNameLang.setZh_CN(assetDefinition.getAssetName());
            assetNameLang.setZh_TW(assetDefinition.getAssetName());
            assetNameLang.setEn_US(assetDefinition.getAssetName());
        }

        MultiLanguageDTO<String> assetDescLang = lang.get("assetDesc");
        if (assetDescLang == null){
            assetDescLang = new MultiLanguageDTO<>();
            lang.put("assetDesc",assetNameLang);
        }

        if (!StringUtils.hasLength(assetDescLang.getZh_CN())){
            assetDescLang.setZh_CN(assetDefinition.getAssetDesc());
            assetDescLang.setZh_TW(assetDefinition.getAssetDesc());
            assetDescLang.setEn_US(assetDefinition.getAssetDesc());
        }

        Asset.ManageContext manageContext = assetDefinition.getManageContext();
        if (manageContext!=null){
            assetDetailResDto.setApplication(manageContext.getApplication());
        }

        AssetPermission permission = assetDefinition.getPermission();
        if (permission!=null){
            assetDetailResDto.setTenantInfos(permission.getTenantInfos());
        }

        return assetDetailResDto;
    }
}
