package com.digiwin.athena.integration.assembly.facade;

import com.digiwin.athena.base.BusinessException;
import com.digiwin.athena.bo.assembly.SolutionPlan;
import com.digiwin.athena.config.AssemblyProp;
import com.digiwin.athena.http.iam.dto.ResultDto;
import com.digiwin.athena.integration.assembly.iam.api.IamApplicationApi;
import com.digiwin.athena.integration.assembly.iam.dto.application.IamCreateApplicationRequest;
import com.digiwin.athena.service.assembly.ApplicationService;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Service;

/**
 * IAM应用服务
 */
@Service
@RequiredArgsConstructor
public class IamApplicationFacadeService implements ApplicationService {

    private final AssemblyProp assemblyProp;
    private final IamApplicationApi iamApplicationApi;

    /**
     * 创建应用
     *
     * @param solutionPlan IAM创建应用请求
     * @param iamToken     IAM用户token
     * @return appSid
     * @see com.digiwin.athena.service.application.impl.ApplicationServiceImpl#iamCreateApplication
     */
    @Override
    public Long createApplication(String iamToken, SolutionPlan solutionPlan) {
        // 1. 构建IAM创建应用请求
        IamCreateApplicationRequest appRequest = IamCreateApplicationRequest.build(
                solutionPlan, assemblyProp.getSolution().getGmcLogoImgUrl());


        ResultDto<Long> responseObj = iamApplicationApi.createApplication(assemblyProp.getAppToken(), iamToken, appRequest);

        if (responseObj.getSuccess()) {
            return responseObj.getData();
        } else {
            throw new BusinessException("IAM failed to create the app, error message:"
                    + responseObj.getMessage());
        }
    }

}
