package com.digiwin.athena.mongodb.domain;

import com.digiwin.athena.datacollect.model.CollectExecutorProp;
import lombok.Data;

import java.time.LocalDateTime;

/**
 * 数据采集配置
 */
@Data
public class DataCollectConfig {

    /**
     * 采集类型（主动/被动）
     */
    private String collectType;

    /**
     * 执行器配置
     */
    private CollectExecutorProp executor;

    /**
     * 触发器配置
     */
    private CollectTrigger trigger;

    /**
     * 配置更新时间
     * 用于检测配置是否变更，变更后需要重新开始采集任务
     */
    private LocalDateTime configUpdateTime;


    /**
     * 数据采集触发器配置
     */
    @Data
    public static class CollectTrigger {

        /**
         * 触发器类型（如：cron）
         */
        private String type;

        /**
         * 触发器值（如：cron表达式 "0 0/5 * * * ?"）
         */
        private String value;
    }

}
