package com.digiwin.athena.controller.assetType;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.digiwin.athena.dto.ResultDto;
import com.digiwin.athena.dto.assetType.AssetTypeCategoryResDto;
import com.digiwin.athena.dto.assetType.AssetTypeResDto;
import com.digiwin.athena.mongodb.domain.other.PresetData;
import com.digiwin.athena.service.assetType.RAssetTypeService;
import com.digiwin.athena.sys.PresetDataServiceV2;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@RestController
@RequestMapping("/assetType/r")
@Tag(name = "运行时资产类型接口",description = "2b425393-ae52-412d-95c4-7d1938f24b61")
public class RAssetTypeController {
    @Autowired
    private RAssetTypeService rAssetTypeService;
    @Autowired
    private PresetDataServiceV2 presetDataServiceV2;
    @GetMapping("/assetTypeMenu")
    @Operation(summary = "获取资产类型菜单")
    public ResultDto<List<AssetTypeCategoryResDto>> assetTypeMenu(){
        List<AssetTypeResDto> assetTypeMenu = rAssetTypeService.assetTypeMenu();
        Map<String, List<AssetTypeResDto>> assetTypeMenuMap = assetTypeMenu.stream().collect(Collectors.groupingBy(a -> a.getCategory()));
        PresetData assetTypeCategory = presetDataServiceV2.getPresetDataObjectV2("ASSET_TYPE_CATEGORY");

        List<AssetTypeCategoryResDto> res = JSONObject.parseObject(JSONObject.toJSONString(assetTypeCategory.getObj()), new TypeReference<>() {
        });
        for (AssetTypeCategoryResDto re : res) {
            re.setAssetTypeResDto(assetTypeMenuMap.get(re.getKey()));
        }

        return ResultDto.createSuccess(res);
    }
}
