package com.digiwin.athena.dto.asset;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.dto.action.MultiLanguageDTO;
import com.digiwin.athena.mongodb.domain.application.AssetDefinition;
import com.digiwin.athena.mongodb.domain.application.AssetDepInfo;
import lombok.Data;

import java.util.Map;

@Data
public class DepAssetResDto {
    private String depId;

    private String assetId;

    private String code;

    private String type;

    private String assetName;

    private String assetDesc;

    private Boolean canReference = false;

    private Boolean canCopy = false;

    private Map<String, MultiLanguageDTO> lang;

    private JSONObject targetManageContext;

    public static DepAssetResDto create(AssetDepInfo depInfo, AssetDefinition assetDefinition) {
        DepAssetResDto depAssetResDto = new DepAssetResDto();
        depAssetResDto.setDepId(depInfo.getObjId());
        depAssetResDto.setTargetManageContext(depInfo.getTargetManageContext());

        depAssetResDto.setAssetId(assetDefinition.getAssetId());
        depAssetResDto.setCode(assetDefinition.getCode());
        depAssetResDto.setType(assetDefinition.getType());
        depAssetResDto.setAssetName(assetDefinition.getAssetName());
        depAssetResDto.setAssetDesc(assetDefinition.getAssetDesc());
        depAssetResDto.setCanReference(assetDefinition.getCanReference());
        depAssetResDto.setCanCopy(assetDefinition.getCanCopy());
        depAssetResDto.setLang(assetDefinition.getLang());

        return depAssetResDto;
    }
}
