package com.digiwin.athena.integration.assembly.gmc.dto.commodity;

import lombok.Data;

import java.util.List;

/**
 * 模组信息
 */
@Data
public class ModulesInfo {

    private String appToken;

    private AppInfo app;

    private List<ModuleItem> modules;

    private List<Object> actions;

    /**
     * 创建模组项（工具方法）
     *
     * @param id   模组ID
     * @param name 模组名称
     * @return 模组项对象
     */
    public static ModulesInfo.ModuleItem createModule(String id, String name) {
        ModulesInfo.ModuleItem module = new ModulesInfo.ModuleItem();
        module.setId(id);
        module.setName(name);
        return module;
    }

    /**
     * 应用信息
     */
    @Data
    public static class AppInfo {

        private String categoryId;

        private String id;

        private String name;

        private Integer isMultiLogin;
    }

    /**
     * 单个模组项
     */
    @Data
    public static class ModuleItem {

        private String id;

        private String name;
    }
}
