package com.digiwin.athena.service.applicationHandler.handler;

import com.digiwin.athena.actuator.HttpActuator;
import com.digiwin.athena.actuator.HttpExecuteConfig;
import com.digiwin.athena.actuator.ReqPlaceholder;
import com.digiwin.athena.bo.assembly.Designer;
import com.digiwin.athena.bo.assembly.SolutionPlan;
import com.digiwin.athena.dto.PageReqCondition;
import com.digiwin.athena.dto.Pagination;
import com.digiwin.athena.dto.ResultDto;
import com.digiwin.athena.dto.assembly.solution.SolutionPlanDetailDTO;
import com.digiwin.athena.dto.asset.AssetCenterInfoResDto;
import com.digiwin.athena.dto.assetType.AssetTypeResDto;
import com.digiwin.athena.enums.DeleteApplicationProcessEnum;
import com.digiwin.athena.mongodb.domain.ApiInfo;
import com.digiwin.athena.mongodb.domain.ExecuteConfig;
import com.digiwin.athena.mongodb.domain.application.Application;
import com.digiwin.athena.service.assembly.RDesignerService;
import com.digiwin.athena.service.assembly.RSolutionPlanService;
import com.digiwin.athena.service.asset.AssetCenter;
import com.digiwin.athena.service.assetType.RAssetTypeService;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@Component
@Slf4j
@RequiredArgsConstructor
public class AssetDeleteHandler extends AbstractDeletionHandler {

    private final AssetCenter assetCenter;
    private final HttpActuator httpActuator;
    private final RSolutionPlanService rSolutionPlanService;
    private final RDesignerService rDesignerService;
    private final RAssetTypeService rAssetTypeService;

    @Override
    protected void doDeleteExecute(Application application) {
        SolutionPlan solutionPlan = rSolutionPlanService.findByAppType(application.getAppType());
        if (solutionPlan == null || CollectionUtils.isEmpty(solutionPlan.getDesignerList())) {
            return;
        }

        List<SolutionPlanDetailDTO.DesignerBaseInfoDTO> designerList = solutionPlan.getDesignerList();
        Set<String> designerIds = designerList.stream().map(d -> d.getId()).collect(Collectors.toSet());
        List<Designer> designerDetailDTOS = rDesignerService.getDesigners(designerIds);

        Set<String> assetTypeIds = designerDetailDTOS.stream()
                .filter(d -> d.getRelatedAssetType() != null && !CollectionUtils.isEmpty(d.getRelatedAssetType().getWrite()))
                .map(d -> d.getRelatedAssetType().getWrite())
                .flatMap(List::stream)
                .map(a -> a.getObjId())
                .collect(Collectors.toSet());
        List<AssetTypeResDto> assetTypes = rAssetTypeService.getAssetTypes(assetTypeIds);

        ObjectMapper mapper = new ObjectMapper();
        for (AssetTypeResDto assetType : assetTypes) {

            List<ApiInfo> apiInfos = Stream.of(assetType.getOpenApiList(), assetType.getApiList())
                    .filter(Objects::nonNull)
                    .flatMap(List::stream)
                    .filter(a -> a.getKey().equals(ApiInfo.KEY_APP_DELETE) && a.getExecuteConfig() != null)
                    .collect(Collectors.toList());

            if (apiInfos.isEmpty()){
                return;
            }

            PageReqCondition<String> pageReqCondition = new PageReqCondition<>();
            pageReqCondition.setPageSize(100);
            Pagination<AssetCenterInfoResDto> pagination = assetCenter.appAssetList(pageReqCondition, List.of(application.getCode()), List.of(assetType.getType()));
            List<AssetCenterInfoResDto> datas = pagination.getData();

            while(!CollectionUtils.isEmpty(datas)){
                for (ApiInfo apiInfo : apiInfos) {
                    ExecuteConfig executeConfig = apiInfo.getExecuteConfig();
                    HttpExecuteConfig httpExecuteConfig = executeConfig.createHttpExecuteConfig();

                    for (AssetCenterInfoResDto data : datas) {
                        Map<String, Object> requestParams = mapper.convertValue(data, new TypeReference<>() {
                        });

                        ResultDto res = (ResultDto) httpActuator.execute(httpExecuteConfig, requestParams, ReqPlaceholder.createParams(null), ResultDto.class);
                        if (res.getCode() != 0) {
                            try {
                                log.error("删除资产数据异常:"+mapper.writeValueAsString(res));
                            } catch (JsonProcessingException e) {
                                throw new RuntimeException(e);
                            }
                            throw new RuntimeException("删除资产数据异常");
                        }
                    }
                }
                pageReqCondition.setPageNum(pageReqCondition.getPageNum() + 1);
                pagination = assetCenter.appAssetList(pageReqCondition, List.of(application.getCode()), List.of(assetType.getType()));
                datas = pagination.getData();
            }

        }

    }

    @Override
    protected void doValidateExecute(Application application) {

    }

    @Override
    protected void doBackup(Application application) {

    }

    @Override
    DeleteApplicationProcessEnum getDeleteType() {
        return DeleteApplicationProcessEnum.DELETE_ASSET;
    }
}
