package com.digiwin.athena.service.assembly.impl;

import com.digiwin.athena.bo.assembly.SolutionPlan;
import com.digiwin.athena.dao.mongodao.assembly.RSolutionMongoDao;
import com.digiwin.athena.dto.PageReqCondition;
import com.digiwin.athena.dto.Pagination;
import com.digiwin.athena.dto.assembly.solution.RSolutionPlanPageQo;
import com.digiwin.athena.dto.assembly.solution.SolutionPlanListDTO;
import com.digiwin.athena.service.assembly.RSolutionPlanService;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.util.HashSet;
import java.util.List;

/**
 * 运行时SolutionPlan列表服务实现
 */
@Slf4j
@Service
@RequiredArgsConstructor
public class RSolutionPlanServiceImpl implements RSolutionPlanService {

    private final RSolutionMongoDao rSolutionMongoDao;

    @Override
    public Pagination<SolutionPlanListDTO> list(PageReqCondition<RSolutionPlanPageQo> pageReqCondition) {
        // TODO pzz 查询运行时设计器最新名称及type
        return rSolutionMongoDao.selectOnlineSolutionPage(pageReqCondition);
    }

    @Override
    public List<SolutionPlanListDTO> findByAppTypeOrAll(List<Integer> appType) {
        return rSolutionMongoDao.selectByAppType(new HashSet<>(appType));
    }

    @Override
    public SolutionPlan findByAppType(Integer appType) {
        return rSolutionMongoDao.selectByAppType(appType);
    }
}
