/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.convertor.assembly;

import com.digiwin.athena.bo.assembly.Designer;
import com.digiwin.athena.convertor.BaseConverter;
import com.digiwin.athena.convertor.assembly.DesignerConvertor;
import com.digiwin.athena.dto.action.MultiLanguageDTO;
import com.digiwin.athena.dto.assembly.designer.DesignerDetailDTO;
import com.digiwin.athena.dto.assembly.designer.DesignerListDTO;
import com.digiwin.athena.dto.assembly.designer.DesignerSaveDTO;
import com.digiwin.athena.dto.assembly.solution.SolutionPlanBaseDTO;
import com.digiwin.athena.dto.assembly.solution.SolutionPlanDetailDTO;
import com.digiwin.athena.dto.assetType.AssetTypeBaseDTO;
import com.digiwin.athena.mongodb.domain.assembly.DesignerEntity;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.mapstruct.factory.Mappers;

public class DesignerConvertorImpl
implements DesignerConvertor {
    private final BaseConverter baseConverter = (BaseConverter)Mappers.getMapper(BaseConverter.class);

    @Override
    public Designer toBO(DesignerEntity designer) {
        List<DesignerDetailDTO.ApiExecInfoDTO> list1;
        if (designer == null) {
            return null;
        }
        Designer designer1 = new Designer();
        designer1.setId(designer.getId());
        designer1.setType(designer.getType());
        designer1.setOwner(designer.getOwner());
        designer1.setName(designer.getName());
        designer1.setVersion(designer.getVersion());
        designer1.setVersionSort(designer.getVersionSort());
        designer1.setStatus(designer.getStatus());
        designer1.setDescription(designer.getDescription());
        designer1.setRelatedAssetType(designer.getRelatedAssetType());
        List<SolutionPlanBaseDTO> list = designer.getRelatedSolutionPlan();
        if (list != null) {
            designer1.setRelatedSolutionPlan(new ArrayList<SolutionPlanBaseDTO>(list));
        }
        if ((list1 = designer.getApiList()) != null) {
            designer1.setApiList(new ArrayList<DesignerDetailDTO.ApiExecInfoDTO>(list1));
        }
        designer1.setIntegrationType(designer.getIntegrationType());
        designer1.setIntegrationConfig(designer.getIntegrationConfig());
        Map<String, MultiLanguageDTO<String>> map = designer.getLang();
        if (map != null) {
            designer1.setLang(new LinkedHashMap<String, MultiLanguageDTO<String>>(map));
        }
        designer1.setPublishTime(this.baseConverter.localDateTime2Date(designer.getPublishTime()));
        designer1.setPublishBy(designer.getPublishBy());
        designer1.setCreateTime(designer.getCreateTime());
        designer1.setEditTime(designer.getEditTime());
        designer1.setCreateBy(designer.getCreateBy());
        designer1.setEditBy(designer.getEditBy());
        return designer1;
    }

    @Override
    public DesignerEntity toPo(Designer designer) {
        List<DesignerDetailDTO.ApiExecInfoDTO> list1;
        if (designer == null) {
            return null;
        }
        DesignerEntity designerEntity = new DesignerEntity();
        designerEntity.setId(designer.getId());
        designerEntity.setType(designer.getType());
        designerEntity.setOwner(designer.getOwner());
        designerEntity.setName(designer.getName());
        designerEntity.setVersion(designer.getVersion());
        designerEntity.setVersionSort(designer.getVersionSort());
        designerEntity.setStatus(designer.getStatus());
        designerEntity.setDescription(designer.getDescription());
        designerEntity.setRelatedAssetType(designer.getRelatedAssetType());
        List<SolutionPlanBaseDTO> list = designer.getRelatedSolutionPlan();
        if (list != null) {
            designerEntity.setRelatedSolutionPlan(new ArrayList<SolutionPlanBaseDTO>(list));
        }
        if ((list1 = designer.getApiList()) != null) {
            designerEntity.setApiList(new ArrayList<DesignerDetailDTO.ApiExecInfoDTO>(list1));
        }
        designerEntity.setIntegrationType(designer.getIntegrationType());
        designerEntity.setIntegrationConfig(designer.getIntegrationConfig());
        Map<String, MultiLanguageDTO<String>> map = designer.getLang();
        if (map != null) {
            designerEntity.setLang(new LinkedHashMap<String, MultiLanguageDTO<String>>(map));
        }
        designerEntity.setPublishTime(this.baseConverter.date2LocalDateTime(designer.getPublishTime()));
        designerEntity.setPublishBy(designer.getPublishBy());
        designerEntity.setCreateTime(designer.getCreateTime());
        designerEntity.setEditTime(designer.getEditTime());
        designerEntity.setCreateBy(designer.getCreateBy());
        designerEntity.setEditBy(designer.getEditBy());
        return designerEntity;
    }

    @Override
    public DesignerListDTO toListDTO(DesignerEntity designer) {
        List<AssetTypeBaseDTO> write;
        List<AssetTypeBaseDTO> list1;
        if (designer == null) {
            return null;
        }
        DesignerListDTO designerListDTO = new DesignerListDTO();
        List<AssetTypeBaseDTO> read = this.designerRelatedAssetTypeRead(designer);
        List<AssetTypeBaseDTO> list = read;
        if (list != null) {
            designerListDTO.setReadAssetType(new ArrayList<AssetTypeBaseDTO>(list));
        }
        if ((list1 = (write = this.designerRelatedAssetTypeWrite(designer))) != null) {
            designerListDTO.setWriteAssetType(new ArrayList<AssetTypeBaseDTO>(list1));
        }
        designerListDTO.setId(designer.getId());
        designerListDTO.setType(designer.getType());
        designerListDTO.setOwner(designer.getOwner());
        designerListDTO.setName(designer.getName());
        designerListDTO.setVersion(designer.getVersion());
        designerListDTO.setStatus(designer.getStatus());
        designerListDTO.setDescription(designer.getDescription());
        List<SolutionPlanBaseDTO> list2 = designer.getRelatedSolutionPlan();
        if (list2 != null) {
            designerListDTO.setRelatedSolutionPlan(new LinkedHashSet<SolutionPlanBaseDTO>(list2));
        }
        designerListDTO.setIntegrationType(designer.getIntegrationType());
        Map<String, MultiLanguageDTO<String>> map = designer.getLang();
        if (map != null) {
            designerListDTO.setLang(new LinkedHashMap<String, MultiLanguageDTO<String>>(map));
        }
        designerListDTO.setPublishTime(designer.getPublishTime());
        designerListDTO.setPublishBy(designer.getPublishBy());
        designerListDTO.setEditTime(designer.getEditTime());
        designerListDTO.setEditBy(designer.getEditBy());
        this.translateDetail(designerListDTO);
        return designerListDTO;
    }

    @Override
    public Designer toBo(DesignerSaveDTO designer) {
        List<DesignerDetailDTO.ApiExecInfoDTO> list1;
        if (designer == null) {
            return null;
        }
        Designer designer1 = new Designer();
        designer1.setId(designer.getId());
        designer1.setType(designer.getType());
        designer1.setOwner(designer.getOwner());
        designer1.setName(designer.getName());
        designer1.setVersion(designer.getVersion());
        designer1.setDescription(designer.getDescription());
        designer1.setRelatedAssetType(designer.getRelatedAssetType());
        List<SolutionPlanBaseDTO> list = designer.getRelatedSolutionPlan();
        if (list != null) {
            designer1.setRelatedSolutionPlan(new ArrayList<SolutionPlanBaseDTO>(list));
        }
        if ((list1 = designer.getApiList()) != null) {
            designer1.setApiList(new ArrayList<DesignerDetailDTO.ApiExecInfoDTO>(list1));
        }
        designer1.setIntegrationType(designer.getIntegrationType());
        designer1.setIntegrationConfig(designer.getIntegrationConfig());
        Map<String, MultiLanguageDTO<String>> map = designer.getLang();
        if (map != null) {
            designer1.setLang(new LinkedHashMap<String, MultiLanguageDTO<String>>(map));
        }
        return designer1;
    }

    @Override
    public DesignerDetailDTO toDto(Designer byId) {
        List<DesignerDetailDTO.ApiExecInfoDTO> list1;
        if (byId == null) {
            return null;
        }
        DesignerDetailDTO designerDetailDTO = new DesignerDetailDTO();
        designerDetailDTO.setId(byId.getId());
        designerDetailDTO.setType(byId.getType());
        designerDetailDTO.setOwner(byId.getOwner());
        designerDetailDTO.setName(byId.getName());
        designerDetailDTO.setVersion(byId.getVersion());
        designerDetailDTO.setStatus(byId.getStatus());
        designerDetailDTO.setDescription(byId.getDescription());
        designerDetailDTO.setRelatedAssetType(byId.getRelatedAssetType());
        List<SolutionPlanBaseDTO> list = byId.getRelatedSolutionPlan();
        if (list != null) {
            designerDetailDTO.setRelatedSolutionPlan(new LinkedHashSet<SolutionPlanBaseDTO>(list));
        }
        if ((list1 = byId.getApiList()) != null) {
            designerDetailDTO.setApiList(new ArrayList<DesignerDetailDTO.ApiExecInfoDTO>(list1));
        }
        designerDetailDTO.setIntegrationType(byId.getIntegrationType());
        designerDetailDTO.setIntegrationConfig(byId.getIntegrationConfig());
        Map<String, MultiLanguageDTO<String>> map = byId.getLang();
        if (map != null) {
            designerDetailDTO.setLang(new LinkedHashMap<String, MultiLanguageDTO<String>>(map));
        }
        designerDetailDTO.setPublishTime(byId.getPublishTime());
        designerDetailDTO.setPublishBy(byId.getPublishBy());
        designerDetailDTO.setCreateTime(byId.getCreateTime());
        designerDetailDTO.setEditTime(byId.getEditTime());
        designerDetailDTO.setCreateBy(byId.getCreateBy());
        designerDetailDTO.setEditBy(byId.getEditBy());
        this.translateList(designerDetailDTO);
        return designerDetailDTO;
    }

    @Override
    public void merge(Designer source, Designer target) {
        if (source == null) {
            return;
        }
        if (source.getId() != null) {
            target.setId(source.getId());
        }
        if (source.getType() != null) {
            target.setType(source.getType());
        }
        if (source.getOwner() != null) {
            target.setOwner(source.getOwner());
        }
        if (source.getName() != null) {
            target.setName(source.getName());
        }
        if (source.getVersion() != null) {
            target.setVersion(source.getVersion());
        }
        if (source.getVersionSort() != null) {
            target.setVersionSort(source.getVersionSort());
        }
        if (source.getStatus() != null) {
            target.setStatus(source.getStatus());
        }
        if (source.getDescription() != null) {
            target.setDescription(source.getDescription());
        }
        if (source.getRelatedAssetType() != null) {
            target.setRelatedAssetType(source.getRelatedAssetType());
        }
        if (target.getRelatedSolutionPlan() != null) {
            list = source.getRelatedSolutionPlan();
            if (list != null) {
                target.getRelatedSolutionPlan().clear();
                target.getRelatedSolutionPlan().addAll(list);
            }
        } else {
            list = source.getRelatedSolutionPlan();
            if (list != null) {
                target.setRelatedSolutionPlan(new ArrayList<SolutionPlanBaseDTO>(list));
            }
        }
        if (target.getApiList() != null) {
            list1 = source.getApiList();
            if (list1 != null) {
                target.getApiList().clear();
                target.getApiList().addAll(list1);
            }
        } else {
            list1 = source.getApiList();
            if (list1 != null) {
                target.setApiList(new ArrayList<DesignerDetailDTO.ApiExecInfoDTO>(list1));
            }
        }
        if (source.getIntegrationType() != null) {
            target.setIntegrationType(source.getIntegrationType());
        }
        if (source.getIntegrationConfig() != null) {
            target.setIntegrationConfig(source.getIntegrationConfig());
        }
        if (target.getLang() != null) {
            map = source.getLang();
            if (map != null) {
                target.getLang().clear();
                target.getLang().putAll(map);
            }
        } else {
            map = source.getLang();
            if (map != null) {
                target.setLang(new LinkedHashMap<String, MultiLanguageDTO<String>>(map));
            }
        }
        if (source.getPublishTime() != null) {
            target.setPublishTime(source.getPublishTime());
        }
        if (source.getPublishBy() != null) {
            target.setPublishBy(source.getPublishBy());
        }
        if (source.getCreateTime() != null) {
            target.setCreateTime(source.getCreateTime());
        }
        if (source.getEditTime() != null) {
            target.setEditTime(source.getEditTime());
        }
        if (source.getCreateBy() != null) {
            target.setCreateBy(source.getCreateBy());
        }
        if (source.getEditBy() != null) {
            target.setEditBy(source.getEditBy());
        }
    }

    @Override
    public SolutionPlanDetailDTO.DesignerBaseInfoDTO toBaseInfoDTO(Designer designer) {
        if (designer == null) {
            return null;
        }
        SolutionPlanDetailDTO.DesignerBaseInfoDTO designerBaseInfoDTO = new SolutionPlanDetailDTO.DesignerBaseInfoDTO();
        designerBaseInfoDTO.setId(designer.getId());
        designerBaseInfoDTO.setType(designer.getType());
        designerBaseInfoDTO.setName(designer.getName());
        Map<String, MultiLanguageDTO<String>> map = designer.getLang();
        if (map != null) {
            designerBaseInfoDTO.setLang(new LinkedHashMap<String, MultiLanguageDTO<String>>(map));
        }
        return designerBaseInfoDTO;
    }

    @Override
    public List<SolutionPlanDetailDTO.DesignerBaseInfoDTO> toBaseInfoDTOList(List<Designer> designers) {
        if (designers == null) {
            return null;
        }
        ArrayList<SolutionPlanDetailDTO.DesignerBaseInfoDTO> list = new ArrayList<SolutionPlanDetailDTO.DesignerBaseInfoDTO>(designers.size());
        for (Designer designer : designers) {
            list.add(this.toBaseInfoDTO(designer));
        }
        return list;
    }

    private List<AssetTypeBaseDTO> designerRelatedAssetTypeRead(DesignerEntity designerEntity) {
        if (designerEntity == null) {
            return null;
        }
        DesignerDetailDTO.RelatedAssetTypeDTO relatedAssetType = designerEntity.getRelatedAssetType();
        if (relatedAssetType == null) {
            return null;
        }
        List<AssetTypeBaseDTO> read = relatedAssetType.getRead();
        if (read == null) {
            return null;
        }
        return read;
    }

    private List<AssetTypeBaseDTO> designerRelatedAssetTypeWrite(DesignerEntity designerEntity) {
        if (designerEntity == null) {
            return null;
        }
        DesignerDetailDTO.RelatedAssetTypeDTO relatedAssetType = designerEntity.getRelatedAssetType();
        if (relatedAssetType == null) {
            return null;
        }
        List<AssetTypeBaseDTO> write = relatedAssetType.getWrite();
        if (write == null) {
            return null;
        }
        return write;
    }
}

