/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.dao.mongodao.assembly;

import cn.hutool.core.util.StrUtil;
import com.digiwin.athena.bo.assembly.Designer;
import com.digiwin.athena.dto.PageReqCondition;
import com.digiwin.athena.dto.Pagination;
import com.digiwin.athena.dto.assembly.designer.DesignerListDTO;
import com.digiwin.athena.dto.assembly.designer.DesignerPageQo;
import com.digiwin.athena.utils.CurThreadInfoUtils;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;

public interface DDesignerMongoDao {
    public static void addSearchNameOrType(Query query, String searchContent) {
        if (StrUtil.isNotBlank((CharSequence)searchContent)) {
            String locale = CurThreadInfoUtils.getLocale();
            Pattern pattern = Pattern.compile(".*" + Pattern.quote(searchContent) + ".*", 2);
            query.addCriteria((CriteriaDefinition)new Criteria().orOperator(new Criteria[]{Criteria.where((String)("lang.name." + locale)).regex(pattern), Criteria.where((String)"type").regex(pattern)}));
        }
    }

    public Designer selectById(String var1);

    public Designer selectByCode(String var1);

    public Designer selectByName(String var1);

    public void save(Designer var1);

    public boolean deleteById(String var1);

    public boolean existsByKey(String var1, String var2, String var3);

    public Pagination<DesignerListDTO> selectPage(PageReqCondition<DesignerPageQo> var1);

    public List<Designer> selectByRelatedAsset(String var1);

    public List<Designer> selectByRelatedAsset(Collection<String> var1);

    public List<Designer> selectByIds(Collection<String> var1);

    public List<Designer> selectWritableDesignersByIds(Collection<String> var1);
}

