/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.service.asset.impl;

import cn.hutool.core.util.StrUtil;
import com.digiwin.athena.base.BusinessException;
import com.digiwin.athena.constants.enums.assembly.AssetCollectOperation;
import com.digiwin.athena.datacollect.api.dto.AssetCollectApiResponse;
import com.digiwin.athena.datacollect.context.CollectContext;
import com.digiwin.athena.dto.TenantInfo;
import com.digiwin.athena.dto.asset.CreateAssetReqDto;
import com.digiwin.athena.dto.asset.DeleteAssetReqDto;
import com.digiwin.athena.http.iam.dto.TenantInfoDto;
import com.digiwin.athena.http.iam.service.TenantInfoService;
import com.digiwin.athena.mongodb.domain.application.Asset;
import com.digiwin.athena.service.asset.AssetCenter;
import com.digiwin.athena.service.asset.AssetDataCollectService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class AssetDataCollectServiceImpl
implements AssetDataCollectService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AssetDataCollectServiceImpl.class);
    private final AssetCenter assetCenterService;
    private final TenantInfoService tenantInfoService;

    @Override
    public int batchUpsertAssets(List<Asset> assets) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int batchProcessDataItems(CollectContext context, List<AssetCollectApiResponse.AssetDataItem> dataItems) throws Exception {
        if (CollectionUtils.isEmpty(dataItems)) {
            return 0;
        }
        HashMap<String, TenantInfo> tenantInfoCache = new HashMap<String, TenantInfo>();
        int successCount = 0;
        for (AssetCollectApiResponse.AssetDataItem item : dataItems) {
            AssetCollectApiResponse.AssetData data = item.getData();
            if (data == null) continue;
            String opStr = item.obtainOp(context.getOpFromLoopParam());
            AssetCollectOperation operationType = AssetCollectOperation.of(opStr);
            if (operationType == null) {
                throw new BusinessException("\u8d44\u4ea7\u91c7\u96c6\u64cd\u4f5c\u7c7b\u578b\u4e0d\u5b58\u5728! op=" + opStr);
            }
            if (operationType.isDelete()) {
                this.processDeleteAssets(data);
            } else {
                this.saveAsset(tenantInfoCache, data);
            }
            ++successCount;
        }
        return successCount;
    }

    private void saveAsset(Map<String, TenantInfo> tenantMap, AssetCollectApiResponse.AssetData data) {
        CreateAssetReqDto dto = null;
        try {
            dto = this.convertToCreateAssetReqDto(data);
            TenantInfo tenantInfo = tenantMap.computeIfAbsent(data.getAdpTenantId(), k -> this.map(this.tenantInfoService.getTenantInfoWithCache(k)));
            this.assetCenterService.saveAsset(dto, tenantInfo);
        }
        catch (Exception e) {
            log.error("\u8d44\u4ea7\u4fdd\u5b58\u5931\u8d25: asset={}, error={}", (Object)dto, (Object)e.getMessage());
            throw new RuntimeException(StrUtil.format((CharSequence)"\u8d44\u4ea7\u4fdd\u5b58\u5931\u8d25: assetCode={},assetType={}", (Object[])new Object[]{data.getCode(), data.getType()}), e);
        }
    }

    protected TenantInfo map(TenantInfoDto dto) {
        TenantInfo tenantInfo = new TenantInfo();
        tenantInfo.setTenantId(dto.getTenantId());
        tenantInfo.setTenantName(dto.getTenantName());
        tenantInfo.setSid(StrUtil.toStringOrNull((Object)dto.getTenantSid()));
        return tenantInfo;
    }

    protected void processDeleteAssets(AssetCollectApiResponse.AssetData data) {
        try {
            this.assetCenterService.deleteAsset(this.buildDeleteDto(data));
            log.info("\u8d44\u4ea7\u5220\u9664\u6210\u529f: assetType Code={}", (Object)data.getKey());
        }
        catch (Exception e) {
            log.error("\u8d44\u4ea7\u5220\u9664\u5931\u8d25: assetType Code={}, error={}", (Object)data.getKey(), (Object)e.getMessage());
            throw new BusinessException("\u8d44\u4ea7\u5220\u9664\u5931\u8d25: assetType Code=" + data.getKey(), (Throwable)e);
        }
    }

    protected DeleteAssetReqDto buildDeleteDto(AssetCollectApiResponse.AssetData data) {
        DeleteAssetReqDto dto = new DeleteAssetReqDto();
        dto.setCode(data.getCode());
        dto.setType(data.getType());
        dto.setManageContext(data.getManageContext());
        return dto;
    }

    protected CreateAssetReqDto convertToCreateAssetReqDto(AssetCollectApiResponse.AssetData data) {
        CreateAssetReqDto dto = new CreateAssetReqDto();
        dto.setCode(data.getCode());
        dto.setType(data.getType());
        dto.setAssetName(data.getAssetName());
        dto.setAssetDesc(data.getAssetDesc());
        dto.setBusinessData(data.getBusinessData());
        dto.setManageContext(data.getManageContext());
        return dto;
    }

    @Generated
    public AssetDataCollectServiceImpl(AssetCenter assetCenterService, TenantInfoService tenantInfoService) {
        this.assetCenterService = assetCenterService;
        this.tenantInfoService = tenantInfoService;
    }
}

