package com.digiwin.athena.integration.assembly.facade.dto;

import cn.hutool.core.collection.CollUtil;
import com.digiwin.athena.config.AssemblyProp;
import lombok.Data;

import java.util.List;

/**
 * 商品多区同步DTO
 */
@Data
public class CommodityMultiEnvSyncDTO {

    private Long appSid;

    private AssemblyProp.EnvConfig envConfig;

    private String token;


    /**
     * 获取应用信息（支持多区域）
     * 用于launch等场景，不创建应用，只获取各区域的token
     *
     * @param iamToken IAM用户token
     * @return 各区域应用信息列表
     */
    public static List<CommodityMultiEnvSyncDTO> buildList(String gmcDomain, String iamToken) {
        return buildList(gmcDomain, iamToken, null);
    }

    public static List<CommodityMultiEnvSyncDTO> buildList(String gmcDomain, String iamToken, Long appSid) {
        AssemblyProp.EnvConfig envConfig = new AssemblyProp.EnvConfig();
        envConfig.setGmcDomain(gmcDomain);

        CommodityMultiEnvSyncDTO appResponse = new CommodityMultiEnvSyncDTO();

        appResponse.setAppSid(appSid);
        appResponse.setEnvConfig(envConfig);
        appResponse.setToken(iamToken);

        return CollUtil.newArrayList(appResponse);
    }
}
