package com.digiwin.athena.integration.assembly.iam.dto.application;

import com.digiwin.athena.bo.assembly.SolutionPlan;
import com.digiwin.athena.dto.action.MultiLanguageDTO;
import lombok.Data;

import java.util.Map;

/**
 * IAM创建应用请求参数
 */
@Data
public class IamCreateApplicationRequest {

    private String id;

    private String nameCN;

    private String nameTW;

    private String nameUS;

    private String logoImageUrl;

    private Integer sysType;

    private String remarks;

    private Boolean nonDev;

    private Integer common;

    private Integer devPlatform;

    private Boolean landingApp;

    private Integer sysCategory;

    private Boolean enableAuth;


    /**
     * 构建IAM创建应用请求
     */
    public static IamCreateApplicationRequest build(SolutionPlan solutionPlan, String logoUrl) {
        IamCreateApplicationRequest request = new IamCreateApplicationRequest();

        // 设置应用ID（使用解决方案的type作为appId）
        request.setId(solutionPlan.getType());

        // 提取多语言名称
        Map<String, MultiLanguageDTO<String>> lang = solutionPlan.getLang();
        if (lang != null && lang.containsKey("name")) {
            MultiLanguageDTO<String> name = lang.get("name");
            request.setNameCN(name.getZh_CN());
            request.setNameTW(name.getZh_TW());
            request.setNameUS(name.getEn_US());
        } else {
            // 如果没有多语言配置，使用默认名称
            request.setNameCN(solutionPlan.getName());
            request.setNameTW(solutionPlan.getName());
            request.setNameUS(solutionPlan.getName());
        }

        // 设置其他固定参数
        request.setLogoImageUrl(logoUrl);
        request.setSysType(1);
        request.setRemarks(solutionPlan.getDescription());
        request.setNonDev(false);
        request.setCommon(0);
        request.setDevPlatform(0);
        request.setLandingApp(false);
        request.setSysCategory(1);
        request.setEnableAuth(null);
        return request;
    }
}
