/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.datacollect.collector.impl;

import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.StrUtil;
import com.digiwin.athena.base.BusinessException;
import com.digiwin.athena.convertor.BaseConverter;
import com.digiwin.athena.datacollect.api.dto.AssetCollectApiRequest;
import com.digiwin.athena.datacollect.api.dto.AssetCollectApiResponse;
import com.digiwin.athena.datacollect.collector.BaseAssetDataCollector;
import com.digiwin.athena.datacollect.context.CollectContext;
import com.digiwin.athena.datacollect.context.HttpRequestContext;
import com.digiwin.athena.datacollect.model.CollectExecutorProp;
import com.digiwin.athena.datacollect.model.PageResult;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.retry.RetryCallback;
import org.springframework.retry.RetryPolicy;
import org.springframework.retry.backoff.BackOffPolicy;
import org.springframework.retry.backoff.ExponentialBackOffPolicy;
import org.springframework.retry.backoff.FixedBackOffPolicy;
import org.springframework.retry.policy.SimpleRetryPolicy;
import org.springframework.retry.support.RetryTemplate;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Component
public class HttpAssetDataCollector
extends BaseAssetDataCollector {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HttpAssetDataCollector.class);
    protected final RestTemplate restTemplate;

    @Override
    public String getType() {
        return "http";
    }

    @Override
    protected PageResult<AssetCollectApiResponse.AssetDataItem> fetchPage(CollectContext collectContext) {
        CollectExecutorProp executor = collectContext.getConfig().getExecutor();
        try {
            HttpRequestContext requestContext = this.buildRequestContext(collectContext, executor);
            this.processRequestScript(executor, requestContext);
            this.execute(executor, requestContext);
            this.processResponseScript(executor, requestContext);
            return this.processResult(collectContext, requestContext, executor);
        }
        catch (Exception e) {
            throw new BusinessException(StrUtil.format((CharSequence)"{}\u6267\u884c\u5668\u5931\u8d25!msg:{}", (Object[])new Object[]{this.getType(), e.getMessage()}), (Throwable)e);
        }
    }

    protected HttpRequestContext buildRequestContext(CollectContext collectContext, CollectExecutorProp executor) {
        HttpRequestContext requestContext = new HttpRequestContext(executor.getUrl(), collectContext);
        requestContext.setRequestHeader(new HashMap<String, Object>(MapUtil.emptyIfNull(executor.getHeaders())));
        requestContext.setRequestBody(AssetCollectApiRequest.buildRequestMap(collectContext));
        return requestContext;
    }

    protected void processRequestScript(CollectExecutorProp executor, HttpRequestContext requestContext) {
        if (StrUtil.isBlank((CharSequence)executor.getRequestScript())) {
            return;
        }
        HttpRequestContext resultContext = this.scriptExecutor.execute(executor.getRequestScript(), requestContext, HttpRequestContext.class);
        if (resultContext == null || requestContext.getRequestBody() == null) {
            log.warn("http\u8bf7\u6c42\u811a\u672c\u6267\u884c\u7ed3\u679c\u4e3anull,\u5ffd\u7565\u811a\u672c\u5904\u7406\uff01");
            return;
        }
        requestContext.setUrl(resultContext.getUrl());
        requestContext.setResponseHeader(resultContext.getResponseHeader());
        requestContext.setRequestBody(resultContext.getRequestBody());
    }

    protected void execute(CollectExecutorProp executor, HttpRequestContext requestContext) {
        HttpHeaders headers = this.buildHeaders(requestContext.getRequestHeader());
        HttpEntity entity = new HttpEntity(requestContext.getRequestBody(), (MultiValueMap)headers);
        if (log.isDebugEnabled()) {
            log.debug("HTTP\u8bf7\u6c42\u53c2\u6570\uff1aurl:{},header:{},body:{}", new Object[]{executor.getUrl(), BaseConverter.INSTANCE.serialize(headers), BaseConverter.INSTANCE.serialize(requestContext.getRequestBody())});
        }
        RetryTemplate dynamicRetryTemplate = this.createRetryTemplate(executor);
        ResponseEntity resp = (ResponseEntity)dynamicRetryTemplate.execute(this.request(executor.getUrl(), entity));
        requestContext.setResponseSuccess(resp.getStatusCode().is2xxSuccessful());
        requestContext.setResponseStatusCode(resp.getStatusCode().value());
        requestContext.setResponseBodyStr((String)resp.getBody());
        requestContext.setResponseBody(resp.getBody());
        requestContext.setResponseHeader(resp.getHeaders().asSingleValueMap());
        String responseBodyStr = (String)requestContext.getResponseBody();
        if (log.isDebugEnabled()) {
            log.debug("HTTP\u8bf7\u6c42\u54cd\u5e94\uff1aurl:{},status:{},body:{}", new Object[]{executor.getUrl(), requestContext.getResponseStatusCode(), responseBodyStr});
        }
    }

    protected RetryCallback<ResponseEntity<String>, RuntimeException> request(String url, HttpEntity<?> entity) {
        return retryContext -> {
            log.debug("\u53d1\u9001HTTP\u8bf7\u6c42: url={}, attempt={}", (Object)url, (Object)(retryContext.getRetryCount() + 1));
            return this.restTemplate.postForEntity(url, (Object)entity, String.class, new Object[0]);
        };
    }

    protected void processResponseScript(CollectExecutorProp executor, HttpRequestContext requestContext) {
        String responseBodyStr = requestContext.getResponseBodyStr();
        if (!requestContext.isResponseSuccess() || StrUtil.isBlank((CharSequence)responseBodyStr)) {
            log.warn("HTTP\u63a5\u53e3\u8fd4\u56de\u975e\u6210\u529f\u72b6\u6001: status={},body:{}", (Object)requestContext.getResponseStatusCode(), (Object)responseBodyStr);
            return;
        }
        if (StrUtil.isBlank((CharSequence)executor.getResponseScript())) {
            AssetCollectApiResponse respBody = this.scriptExecutor.convertResult(responseBodyStr, AssetCollectApiResponse.class);
            requestContext.setResponseBody(respBody);
            return;
        }
        Map responseBodyMap = this.scriptExecutor.convertResult(responseBodyStr, Map.class);
        requestContext.setResponseBody(responseBodyMap);
        HttpRequestContext result = this.scriptExecutor.execute(executor.getResponseScript(), requestContext, HttpRequestContext.class);
        if (result == null || result.getResponseBody() == null) {
            log.warn("http\u54cd\u5e94\u811a\u672c\u6267\u884c\u7ed3\u679c\u4e3anull,\u5ffd\u7565\u811a\u672c\u5904\u7406\uff01");
            return;
        }
        requestContext.setResponseBody(this.scriptExecutor.convertResult(result.getResponseBody(), AssetCollectApiResponse.class));
    }

    protected PageResult<AssetCollectApiResponse.AssetDataItem> processResult(CollectContext collectContext, HttpRequestContext requestContext, CollectExecutorProp executor) {
        AssetCollectApiResponse responseBody = (AssetCollectApiResponse)requestContext.getResponseBody();
        if (responseBody != null) {
            return this.convertToPageResult(responseBody, collectContext.getPageNo(), collectContext.getPageSize());
        }
        log.error("HTTP\u8bf7\u6c42\u5931\u8d25: status={}, url={},body:{}", new Object[]{requestContext.getResponseStatusCode(), executor.getUrl(), requestContext.getResponseBodyStr()});
        return new PageResult<AssetCollectApiResponse.AssetDataItem>(new ArrayList(), collectContext.getPageNo(), collectContext.getPageSize());
    }

    protected RetryTemplate createRetryTemplate(CollectExecutorProp executor) {
        RetryTemplate template = new RetryTemplate();
        CollectExecutorProp.Retry retry = executor.getRetry();
        if (retry == null || !retry.isEnabled()) {
            SimpleRetryPolicy retryPolicy = new SimpleRetryPolicy();
            retryPolicy.setMaxAttempts(1);
            template.setRetryPolicy((RetryPolicy)retryPolicy);
            return template;
        }
        SimpleRetryPolicy retryPolicy = new SimpleRetryPolicy();
        retryPolicy.setMaxAttempts(retry.getMaxAttempts());
        template.setRetryPolicy((RetryPolicy)retryPolicy);
        if (retry.getMultiplier() > 1.0) {
            ExponentialBackOffPolicy backOffPolicy = new ExponentialBackOffPolicy();
            backOffPolicy.setInitialInterval(retry.getInterval());
            backOffPolicy.setMaxInterval(retry.getMaxInterval());
            backOffPolicy.setMultiplier(retry.getMultiplier());
            template.setBackOffPolicy((BackOffPolicy)backOffPolicy);
            log.debug("\u914d\u7f6e\u6307\u6570\u9000\u907f\u7b56\u7565: initialInterval={}ms, maxInterval={}ms, multiplier={}", new Object[]{backOffPolicy.getInitialInterval(), backOffPolicy.getMaxInterval(), backOffPolicy.getMultiplier()});
        } else {
            FixedBackOffPolicy backOffPolicy = new FixedBackOffPolicy();
            backOffPolicy.setBackOffPeriod(retry.getInterval());
            template.setBackOffPolicy((BackOffPolicy)backOffPolicy);
            log.debug("\u914d\u7f6e\u56fa\u5b9a\u9000\u907f\u7b56\u7565: interval={}ms", (Object)backOffPolicy.getBackOffPeriod());
        }
        return template;
    }

    protected HttpHeaders buildHeaders(Map<String, Object> headersConfig) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        if (headersConfig != null && !headersConfig.isEmpty()) {
            for (Map.Entry<String, Object> entry : headersConfig.entrySet()) {
                headers.set(entry.getKey(), String.valueOf(entry.getValue()));
            }
        }
        return headers;
    }

    protected PageResult<AssetCollectApiResponse.AssetDataItem> convertToPageResult(AssetCollectApiResponse apiResponse, Integer pageNo, int pageSize) {
        if (apiResponse == null || !apiResponse.success()) {
            log.warn("HTTP\u63a5\u53e3\u8fd4\u56de\u975e\u6210\u529f\u72b6\u6001: code={}", (Object)(apiResponse != null ? apiResponse.getCode() : null));
            return new PageResult<AssetCollectApiResponse.AssetDataItem>(new ArrayList(), pageNo, pageSize);
        }
        List<AssetCollectApiResponse.AssetDataItem> dataItems = apiResponse.getData();
        if (CollectionUtils.isEmpty(dataItems)) {
            return new PageResult<AssetCollectApiResponse.AssetDataItem>(new ArrayList(), pageNo, pageSize);
        }
        boolean hasMore = dataItems.size() >= pageSize;
        PageResult<AssetCollectApiResponse.AssetDataItem> pageResult = new PageResult<AssetCollectApiResponse.AssetDataItem>();
        pageResult.setData(dataItems);
        pageResult.setHasMore(hasMore);
        pageResult.setCurrentPage(pageNo);
        pageResult.setCurrentPageSize(dataItems.size());
        return pageResult;
    }

    @Generated
    public HttpAssetDataCollector(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
    }
}

