package com.digiwin.athena.dto.common;

import lombok.Data;

import java.util.Map;

@Data
public class HttpExecutorConfigVal {

    /**
     * 请求URL（支持表达式）
     */
    private String url;

    /**
     * 请求头配置（支持表达式）
     */
    private Map<String, Object> headers;


    /**
     * 请求前置脚本
     * 用于在发送HTTP请求前对url、requestBody、requestHeader进行处理
     * 脚本输入：url, requestBody, requestHeader
     * 脚本输出：处理后的requestBody和requestHeader
     */
    private String requestScript;

    /**
     * 响应后置脚本
     * 用于在接收HTTP响应后对响应数据进行处理
     * 脚本输入：responseBody
     * 脚本输出：处理后的responseBody
     */
    private String responseScript;
}
