package com.digiwin.athena.controller.assembly;

import com.digiwin.athena.dto.PageReqCondition;
import com.digiwin.athena.dto.Pagination;
import com.digiwin.athena.dto.ResultDto;
import com.digiwin.athena.dto.assembly.designer.DesignerListDTO;
import com.digiwin.athena.dto.assembly.designer.RDesignerPageQo;
import com.digiwin.athena.service.assembly.RDesignerService;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 设计器运行时
 */
@Slf4j
@RestController
@RequestMapping("/assembly/designer/r/")
@RequiredArgsConstructor
public class RDesignerController {

    private final RDesignerService RDesignerService;

    /**
     * 列表
     */
    @PostMapping("/list")
    public ResultDto<Pagination<DesignerListDTO>> getOnlineDesignerList(@RequestBody PageReqCondition<RDesignerPageQo> pageReqCondition) {
        log.debug("收到分页查询在线状态设计器列表请求");
        Pagination<DesignerListDTO> result = RDesignerService.getOnlineDesignerPage(pageReqCondition);
        return ResultDto.createSuccess(result);
    }
}
