package com.digiwin.athena.dto.asset;

import com.digiwin.athena.dto.action.MultiLanguageDTO;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import lombok.Data;

import java.util.Map;

@Data
public class UpdateAssetBasicInfoReqDto {

    @NotEmpty(message = "资产id不能为空")
    private String assetId;
    @NotEmpty(message = "资产名称不能为空")
    private String assetName;
    @NotNull(message = "多语言不能为空")
    private Map<String, MultiLanguageDTO> lang;
}
