package com.digiwin.athena.dao.mongodao.assembly.impl;

import com.digiwin.athena.dao.mongodao.assembly.ApplicationDataMongoDao;
import com.digiwin.athena.mongodb.domain.assembly.ApplicationData;
import com.digiwin.athena.mongodb.repository.MongoPrimaryRepositoryDecorator;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Repository;

/**
 * 应用数据DAO实现
 */
@Slf4j
@Repository
@RequiredArgsConstructor
public class ApplicationDataMongoDaoImpl implements ApplicationDataMongoDao {

    private final MongoPrimaryRepositoryDecorator decorator;

    @Override
    public ApplicationData selectByAppCode(String appCode) {
        Criteria criteria = Criteria.where(ApplicationData.Fields.appCode).is(appCode);
        Query query = new Query(criteria);
        return decorator.findOne(query, ApplicationData.class);
    }

    @Override
    public void save(ApplicationData applicationData) {
        applicationData.prepareSave();
        decorator.save(applicationData);
    }
}
