package com.digiwin.athena.dto.assembly.solution;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.digiwin.athena.constants.enums.assembly.AssemblyType;
import com.digiwin.athena.constants.enums.assembly.OnlineState;
import lombok.AccessLevel;
import lombok.Data;
import lombok.Getter;

import java.util.List;

@Data
public class SolutionPlanPageQo {
    private String searchContent; // 解决方案名称（可选）

    /**
     * @see AssemblyType#getCode()
     */
    @Getter(AccessLevel.NONE)
    private String assemblyType;

    /**
     * @see AssemblyType#getCode()
     */
    private List<String> assemblyTypeList;             // 组装类型列表（可选）：01-可组装 02-不可组装

    /**
     * @see OnlineState#getCode()
     */
    @Getter(AccessLevel.NONE)
    private String solutionState;

    /**
     * @see OnlineState#getCode()
     */
    private List<String> solutionStateList;            // 状态列表（可选）：01-草稿 02-未上架 03-已上架


    public List<String> getAssemblyTypeList() {
        if (StrUtil.isNotBlank(assemblyType)) {
            return CollUtil.toList(assemblyType);
        }

        return assemblyTypeList;
    }

    public List<String> getSolutionStateList() {
        if (StrUtil.isNotBlank(solutionState)) {
            return CollUtil.toList(solutionState);
        }

        return solutionStateList;
    }

}
