package com.digiwin.athena.dto.asset;

import com.digiwin.athena.dto.action.MultiLanguageDTO;
import com.digiwin.athena.mongodb.domain.application.Asset;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import lombok.Data;

import java.util.Map;

@Data
public class UpdateAssetBasicInfoReqDto {

    private String assetId;

    private String code;
    private String type;

    @NotEmpty(message = "资产名称不能为空")
    private String assetName;
    @NotNull(message = "多语言不能为空")
    private Map<String, MultiLanguageDTO> lang;

    private Asset.ManageContext manageContext = new Asset.ManageContext();
}
