/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.integration.assembly.facade;

import com.digiwin.athena.base.BusinessException;
import com.digiwin.athena.bo.assembly.SolutionPlan;
import com.digiwin.athena.config.AssemblyProp;
import com.digiwin.athena.http.iam.service.AppTokenService;
import com.digiwin.athena.integration.assembly.facade.IamApplicationFacadeService;
import com.digiwin.athena.integration.assembly.facade.dto.CommodityMultiEnvSyncDTO;
import com.digiwin.athena.integration.assembly.gmc.api.GmcCommodityApi;
import com.digiwin.athena.integration.assembly.gmc.dto.commodity.CreateCommodityRequest;
import com.digiwin.athena.integration.assembly.gmc.dto.commodity.GmcResultDto;
import com.digiwin.athena.integration.assembly.gmc.dto.commodity.ModulesInfo;
import com.digiwin.athena.integration.assembly.gmc.dto.commodity.UpdateModulesRequest;
import com.digiwin.athena.service.assembly.CommodityService;
import com.digiwin.athena.utils.user.UserHelper;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class GmcCommodityFacadeService
implements CommodityService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GmcCommodityFacadeService.class);
    private final AssemblyProp assemblyProp;
    private final AppTokenService appTokenService;
    private final IamApplicationFacadeService iamApplicationService;
    private final GmcCommodityApi commodityApi;

    @Override
    public void syncSolutionPlan(boolean firstPublish, SolutionPlan solutionPlan) {
        try {
            String iamToken = UserHelper.getCurrentIamToken();
            if (firstPublish) {
                this.createApplicationAndCommodity(solutionPlan, iamToken);
            }
            this.updateCommodity(iamToken, solutionPlan);
        }
        catch (Exception e) {
            log.error("\u89e3\u51b3\u65b9\u6848[{}]\u53d1\u5e03\u65f6\u521b\u5efa\u5e94\u7528\u6216\u5546\u54c1\u5931\u8d25: {}", (Object)solutionPlan.getName(), (Object)e.getMessage());
            throw new BusinessException("\u53d1\u5e03\u5931\u8d25\uff1a" + e.getMessage(), (Throwable)e);
        }
    }

    protected void createApplicationAndCommodity(SolutionPlan solutionPlan, String iamToken) {
        Long appSid = this.iamApplicationService.createApplication(iamToken, solutionPlan);
        List<CommodityMultiEnvSyncDTO> multiEnvSyncList = CommodityMultiEnvSyncDTO.buildList(this.assemblyProp.getGmcDomain(), iamToken, appSid);
        log.info("\u89e3\u51b3\u65b9\u6848[{}]\u521b\u5efa\u5e94\u7528\u6210\u529f\uff0c\u5171{}\u4e2a\u533a\u57df", (Object)solutionPlan.getName(), (Object)multiEnvSyncList.size());
        CreateCommodityRequest commodityRequest = CreateCommodityRequest.build(solutionPlan.getType(), this.assemblyProp.getProductCode());
        this.invokeCreateCommodity(commodityRequest, multiEnvSyncList);
        log.info("\u89e3\u51b3\u65b9\u6848[{}]\u521b\u5efa\u5546\u54c1\u6210\u529f", (Object)solutionPlan.getName());
    }

    protected void updateCommodity(String iamToken, SolutionPlan solutionPlan) {
        String appToken = this.appTokenService.findAppTokenByCode(this.assemblyProp.getAppToken(), iamToken, solutionPlan.getType());
        List<CommodityMultiEnvSyncDTO> appInfo = CommodityMultiEnvSyncDTO.buildList(this.assemblyProp.getGmcDomain(), iamToken);
        UpdateModulesRequest updateRequest = UpdateModulesRequest.build(solutionPlan.getType(), solutionPlan.getName(), appToken, new ArrayList<ModulesInfo.ModuleItem>());
        this.invokeUpdateCommodity(updateRequest, appInfo);
        log.info("\u89e3\u51b3\u65b9\u6848[{}]\u53d1\u5e03\u5e76\u66f4\u65b0\u5546\u54c1\u6210\u529f", (Object)solutionPlan.getName());
    }

    protected void invokeCreateCommodity(CreateCommodityRequest request, List<CommodityMultiEnvSyncDTO> envList) {
        for (CommodityMultiEnvSyncDTO envDto : envList) {
            AssemblyProp.EnvConfig envConfig = envDto.getEnvConfig();
            String iamToken = envDto.getToken();
            String gmcDomain = envConfig.getGmcDomain();
            String url = gmcDomain + "/api/cloudgoods/auto/deploy";
            GmcResultDto<Boolean> responseObj = this.commodityApi.createCommodity(url, this.assemblyProp.getAppToken(), iamToken, request);
            if (responseObj.isSuccess()) continue;
            throw new BusinessException("GMC failed to create the product, error message:" + responseObj.getErrorMessage());
        }
    }

    protected void invokeUpdateCommodity(UpdateModulesRequest request, List<CommodityMultiEnvSyncDTO> appInfo) {
        for (CommodityMultiEnvSyncDTO response : appInfo) {
            AssemblyProp.EnvConfig envConfig = response.getEnvConfig();
            String token = response.getToken();
            String gmcUrl = envConfig.getGmcDomain() + "/api/cloudgoods/modules";
            GmcResultDto<Void> responseObj = this.commodityApi.updateCommodity(gmcUrl, this.assemblyProp.getAppToken(), token, request);
            if (responseObj.isSuccess()) continue;
            throw new BusinessException("\u66f4\u65b0\u5546\u54c1\u57fa\u7840\u4fe1\u606f\u5931\u8d25!msg:" + responseObj.getErrorMessage());
        }
    }

    @Generated
    public GmcCommodityFacadeService(AssemblyProp assemblyProp, AppTokenService appTokenService, IamApplicationFacadeService iamApplicationService, GmcCommodityApi commodityApi) {
        this.assemblyProp = assemblyProp;
        this.appTokenService = appTokenService;
        this.iamApplicationService = iamApplicationService;
        this.commodityApi = commodityApi;
    }
}

