/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.datacollect.listener;

import com.digiwin.athena.constants.enums.assembly.OnlineState;
import com.digiwin.athena.datacollect.job.AssetQuartzJobManager;
import com.digiwin.athena.event.AssetTypeEvent;
import com.digiwin.athena.event.EventOperation;
import com.digiwin.athena.mongodb.domain.DataCollectConfig;
import com.digiwin.athena.mongodb.domain.assetType.AssetType;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;

@Component
public class DataCollectEventListener {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DataCollectEventListener.class);
    private final AssetQuartzJobManager quartzJobManager;

    @EventListener
    public void handleAssetTypeEvent(AssetTypeEvent event) {
        if (event == null || event.getAssetType() == null) {
            return;
        }
        AssetType assetType = event.getAssetType();
        EventOperation operation = event.getOperation();
        String assetTypeId = assetType.getObjId();
        String type = assetType.getType();
        log.info("\u63a5\u6536\u5230\u8d44\u4ea7\u7c7b\u578b\u4e8b\u4ef6: type={}, assetTypeId={}, operation={}, status={}", new Object[]{type, assetTypeId, operation, assetType.getStatus()});
        try {
            switch (operation) {
                case UPDATE: {
                    this.handleCreateOrUpdateEvent(assetType, operation);
                    break;
                }
                case DELETE: {
                    this.handleDeleteEvent(assetType);
                    break;
                }
                default: {
                    log.warn("\u672a\u77e5\u7684\u4e8b\u4ef6\u64cd\u4f5c\u7c7b\u578b: {}", (Object)operation);
                    break;
                }
            }
        }
        catch (Exception e) {
            log.error("\u5904\u7406\u8d44\u4ea7\u7c7b\u578b\u4e8b\u4ef6\u5931\u8d25: type={}, assetTypeId={}, operation={}", new Object[]{type, assetTypeId, operation, e});
        }
    }

    protected void handleCreateOrUpdateEvent(AssetType assetType, EventOperation operation) {
        String assetTypeId = assetType.getObjId();
        String type = assetType.getType();
        String status = assetType.getStatus();
        DataCollectConfig config = DataCollectConfig.fromAssetType(assetType);
        if (config == null || config.getTrigger() == null) {
            log.debug("\u8d44\u4ea7\u7c7b\u578b\u672a\u5f00\u542f\u6570\u636e\u91c7\u96c6: type={}, assetTypeId={}", (Object)type, (Object)assetTypeId);
            if (this.quartzJobManager.jobExists(assetTypeId)) {
                this.quartzJobManager.deleteJob(assetTypeId);
            }
            return;
        }
        String cronExpression = config.getTrigger().getValue();
        if (OnlineState.Online.getCode().equals(status)) {
            boolean success = this.quartzJobManager.addOrUpdateJob(assetTypeId, cronExpression);
            if (success) {
                log.info("\u542f\u52a8/\u66f4\u65b0\u6570\u636e\u91c7\u96c6\u5b9a\u65f6\u4efb\u52a1\u6210\u529f: type={}, assetTypeId={}, cron={}", new Object[]{type, assetTypeId, cronExpression});
            } else {
                log.error("\u542f\u52a8/\u66f4\u65b0\u6570\u636e\u91c7\u96c6\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25: type={}, assetTypeId={}", (Object)type, (Object)assetTypeId);
            }
        } else if ((OnlineState.Offline.getCode().equals(status) || OnlineState.Draft.getCode().equals(status)) && EventOperation.UPDATE.equals((Object)operation) && this.quartzJobManager.jobExists(assetTypeId)) {
            boolean success = this.quartzJobManager.pauseJob(assetTypeId);
            if (success) {
                log.info("\u6682\u505c\u6570\u636e\u91c7\u96c6\u5b9a\u65f6\u4efb\u52a1\u6210\u529f: type={}, assetTypeId={}", (Object)type, (Object)assetTypeId);
            } else {
                log.error("\u6682\u505c\u6570\u636e\u91c7\u96c6\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25: type={}, assetTypeId={}", (Object)type, (Object)assetTypeId);
            }
        }
    }

    protected void handleDeleteEvent(AssetType assetType) {
        String assetTypeId = assetType.getObjId();
        String type = assetType.getType();
        if (this.quartzJobManager.jobExists(assetTypeId)) {
            boolean success = this.quartzJobManager.deleteJob(assetTypeId);
            if (success) {
                log.info("\u5220\u9664\u6570\u636e\u91c7\u96c6\u5b9a\u65f6\u4efb\u52a1\u6210\u529f: type={}, assetTypeId={}", (Object)type, (Object)assetTypeId);
            } else {
                log.error("\u5220\u9664\u6570\u636e\u91c7\u96c6\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25: type={}, assetTypeId={}", (Object)type, (Object)assetTypeId);
            }
        } else {
            log.debug("\u5b9a\u65f6\u4efb\u52a1\u4e0d\u5b58\u5728\uff0c\u65e0\u9700\u5220\u9664: type={}, assetTypeId={}", (Object)type, (Object)assetTypeId);
        }
    }

    @Generated
    public DataCollectEventListener(AssetQuartzJobManager quartzJobManager) {
        this.quartzJobManager = quartzJobManager;
    }
}

