package com.digiwin.athena.constants.enums.assembly;

import cn.hutool.core.util.StrUtil;
import com.digiwin.athena.constants.enums.BaseLangEnum;
import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 资产操作类型枚举
 */
@Getter
@AllArgsConstructor
public enum AssetCollectOperation implements BaseLangEnum<String> {
    /**
     * 插入操作
     */
    INSERT("insert", "插入", "插入", "Insert"),
    /**
     * 更新操作
     */
    UPDATE("update", "更新", "更新", "Update"),
    /**
     * 删除操作
     */
    DELETE("delete", "删除", "删除", "Delete"),
    /**
     * 插入或更新操作
     */
    UPSERT("upsert", "保存", "保存", "Upsert");

    private final String code;
    private final String descZhCn;
    private final String descZhTw;
    private final String descEnUs;

    /**
     * 根据操作类型字符串获取枚举
     *
     * @param opStr 操作类型字符串
     * @return 枚举值，未找到则返回null
     */
    public static AssetCollectOperation of(String opStr) {
        if (StrUtil.isBlank(opStr)) {
            return null;
        }

        for (AssetCollectOperation type : values()) {
            if (type.code.equalsIgnoreCase(opStr)) {
                return type;
            }
        }

        return null;
    }

    /**
     * 判断是否为删除操作
     *
     * @return true表示删除操作
     */
    public boolean isDelete() {
        return this == DELETE;
    }
}
