package com.digiwin.athena.convertor.assembly;

import com.digiwin.athena.bo.assembly.Designer;
import com.digiwin.athena.convertor.BaseConverter;
import com.digiwin.athena.dto.assembly.designer.DesignerDetailDTO;
import com.digiwin.athena.dto.assembly.designer.DesignerListDTO;
import com.digiwin.athena.dto.assembly.designer.DesignerSaveDTO;
import com.digiwin.athena.dto.assembly.solution.SolutionPlanDetailDTO;
import com.digiwin.athena.mongodb.domain.assembly.DesignerEntity;
import org.mapstruct.*;
import org.mapstruct.factory.Mappers;

import java.util.List;

/**
 * 设计器对象转换器
 */
@Mapper(uses = {BaseConverter.class})
public interface DesignerConvertor {

    DesignerConvertor INSTANCE = Mappers.getMapper(DesignerConvertor.class);

    Designer toBO(DesignerEntity designer);

    DesignerEntity toPo(Designer designer);


    @Mapping(source = "relatedAssetType.read", target = "readAssetType")
    @Mapping(source = "relatedAssetType.write", target = "writeAssetType")
    DesignerListDTO toListDTO(DesignerEntity designer);

    @BeanMapping(unmappedTargetPolicy = ReportingPolicy.IGNORE)
    Designer toBo(DesignerSaveDTO designer);

    DesignerDetailDTO toDto(Designer byId);

    @BeanMapping(nullValuePropertyMappingStrategy = NullValuePropertyMappingStrategy.IGNORE)
    void merge(Designer source, @MappingTarget Designer target);

    @AfterMapping
    default void translateDetail(@MappingTarget DesignerListDTO dto) {
        BaseConverter.INSTANCE.translateDictField(dto);
    }

    @AfterMapping
    default void translateList(@MappingTarget DesignerDetailDTO dto) {
        BaseConverter.INSTANCE.translateDictField(dto);
    }

    SolutionPlanDetailDTO.DesignerBaseInfoDTO toBaseInfoDTO(Designer designer);

    List<SolutionPlanDetailDTO.DesignerBaseInfoDTO> toBaseInfoDTOList(List<Designer> designers);

}
