/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.config;

import cn.hutool.extra.spring.SpringUtil;
import jakarta.annotation.PostConstruct;
import jakarta.validation.constraints.Min;
import java.time.Duration;
import java.time.LocalDateTime;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;
import org.springframework.boot.context.properties.NestedConfigurationProperty;

public class AssemblyProp {
    private String appToken;
    private String iamDomain;
    private String gmcDomain;
    @NestedConfigurationProperty
    private SolutionProp solution = new SolutionProp();
    @NestedConfigurationProperty
    private DataCollector collector = new DataCollector();
    @NestedConfigurationProperty
    private JobProp job = new JobProp();
    private String productCode = "lcdp";

    @PostConstruct
    public void init() {
        if (this.appToken == null) {
            this.appToken = SpringUtil.getProperty((String)"rest-url.appToken");
        }
        if (this.iamDomain == null) {
            this.iamDomain = SpringUtil.getProperty((String)"module.iam.domain");
        }
        if (this.gmcDomain == null) {
            this.gmcDomain = SpringUtil.getProperty((String)"module.gmc.domain");
        }
        if (this.solution.gmcLogoImgUrl == null) {
            this.solution.gmcLogoImgUrl = SpringUtil.getProperty((String)"module.iam.app-logo");
        }
    }

    @Generated
    public AssemblyProp() {
    }

    @Generated
    public String getAppToken() {
        return this.appToken;
    }

    @Generated
    public String getIamDomain() {
        return this.iamDomain;
    }

    @Generated
    public String getGmcDomain() {
        return this.gmcDomain;
    }

    @Generated
    public SolutionProp getSolution() {
        return this.solution;
    }

    @Generated
    public DataCollector getCollector() {
        return this.collector;
    }

    @Generated
    public JobProp getJob() {
        return this.job;
    }

    @Generated
    public String getProductCode() {
        return this.productCode;
    }

    @Generated
    public void setAppToken(String appToken) {
        this.appToken = appToken;
    }

    @Generated
    public void setIamDomain(String iamDomain) {
        this.iamDomain = iamDomain;
    }

    @Generated
    public void setGmcDomain(String gmcDomain) {
        this.gmcDomain = gmcDomain;
    }

    @Generated
    public void setSolution(SolutionProp solution) {
        this.solution = solution;
    }

    @Generated
    public void setCollector(DataCollector collector) {
        this.collector = collector;
    }

    @Generated
    public void setJob(JobProp job) {
        this.job = job;
    }

    @Generated
    public void setProductCode(String productCode) {
        this.productCode = productCode;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AssemblyProp)) {
            return false;
        }
        AssemblyProp other = (AssemblyProp)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$appToken = this.getAppToken();
        String other$appToken = other.getAppToken();
        if (this$appToken == null ? other$appToken != null : !this$appToken.equals(other$appToken)) {
            return false;
        }
        String this$iamDomain = this.getIamDomain();
        String other$iamDomain = other.getIamDomain();
        if (this$iamDomain == null ? other$iamDomain != null : !this$iamDomain.equals(other$iamDomain)) {
            return false;
        }
        String this$gmcDomain = this.getGmcDomain();
        String other$gmcDomain = other.getGmcDomain();
        if (this$gmcDomain == null ? other$gmcDomain != null : !this$gmcDomain.equals(other$gmcDomain)) {
            return false;
        }
        SolutionProp this$solution = this.getSolution();
        SolutionProp other$solution = other.getSolution();
        if (this$solution == null ? other$solution != null : !((Object)this$solution).equals(other$solution)) {
            return false;
        }
        DataCollector this$collector = this.getCollector();
        DataCollector other$collector = other.getCollector();
        if (this$collector == null ? other$collector != null : !((Object)this$collector).equals(other$collector)) {
            return false;
        }
        JobProp this$job = this.getJob();
        JobProp other$job = other.getJob();
        if (this$job == null ? other$job != null : !((Object)this$job).equals(other$job)) {
            return false;
        }
        String this$productCode = this.getProductCode();
        String other$productCode = other.getProductCode();
        return !(this$productCode == null ? other$productCode != null : !this$productCode.equals(other$productCode));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AssemblyProp;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $appToken = this.getAppToken();
        result = result * 59 + ($appToken == null ? 43 : $appToken.hashCode());
        String $iamDomain = this.getIamDomain();
        result = result * 59 + ($iamDomain == null ? 43 : $iamDomain.hashCode());
        String $gmcDomain = this.getGmcDomain();
        result = result * 59 + ($gmcDomain == null ? 43 : $gmcDomain.hashCode());
        SolutionProp $solution = this.getSolution();
        result = result * 59 + ($solution == null ? 43 : ((Object)$solution).hashCode());
        DataCollector $collector = this.getCollector();
        result = result * 59 + ($collector == null ? 43 : ((Object)$collector).hashCode());
        JobProp $job = this.getJob();
        result = result * 59 + ($job == null ? 43 : ((Object)$job).hashCode());
        String $productCode = this.getProductCode();
        result = result * 59 + ($productCode == null ? 43 : $productCode.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "AssemblyProp(appToken=" + this.getAppToken() + ", iamDomain=" + this.getIamDomain() + ", gmcDomain=" + this.getGmcDomain() + ", solution=" + this.getSolution() + ", collector=" + this.getCollector() + ", job=" + this.getJob() + ", productCode=" + this.getProductCode() + ")";
    }

    public static class SolutionProp {
        private String gmcLogoImgUrl;

        @Generated
        public SolutionProp() {
        }

        @Generated
        public String getGmcLogoImgUrl() {
            return this.gmcLogoImgUrl;
        }

        @Generated
        public void setGmcLogoImgUrl(String gmcLogoImgUrl) {
            this.gmcLogoImgUrl = gmcLogoImgUrl;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SolutionProp)) {
                return false;
            }
            SolutionProp other = (SolutionProp)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$gmcLogoImgUrl = this.getGmcLogoImgUrl();
            String other$gmcLogoImgUrl = other.getGmcLogoImgUrl();
            return !(this$gmcLogoImgUrl == null ? other$gmcLogoImgUrl != null : !this$gmcLogoImgUrl.equals(other$gmcLogoImgUrl));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof SolutionProp;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $gmcLogoImgUrl = this.getGmcLogoImgUrl();
            result = result * 59 + ($gmcLogoImgUrl == null ? 43 : $gmcLogoImgUrl.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "AssemblyProp.SolutionProp(gmcLogoImgUrl=" + this.getGmcLogoImgUrl() + ")";
        }
    }

    public static class DataCollector {
        @Range(min=1L, max=10000L)
        private @Range(min=1L, max=10000L) int pageSize = 100;
        @Range(min=1L)
        private @Range(min=1L) Duration stepSpan = Duration.ofHours(10L);
        private LocalDateTime startTime;

        @Generated
        public DataCollector() {
        }

        @Generated
        public int getPageSize() {
            return this.pageSize;
        }

        @Generated
        public Duration getStepSpan() {
            return this.stepSpan;
        }

        @Generated
        public LocalDateTime getStartTime() {
            return this.startTime;
        }

        @Generated
        public void setPageSize(int pageSize) {
            this.pageSize = pageSize;
        }

        @Generated
        public void setStepSpan(Duration stepSpan) {
            this.stepSpan = stepSpan;
        }

        @Generated
        public void setStartTime(LocalDateTime startTime) {
            this.startTime = startTime;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DataCollector)) {
                return false;
            }
            DataCollector other = (DataCollector)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getPageSize() != other.getPageSize()) {
                return false;
            }
            Duration this$stepSpan = this.getStepSpan();
            Duration other$stepSpan = other.getStepSpan();
            if (this$stepSpan == null ? other$stepSpan != null : !((Object)this$stepSpan).equals(other$stepSpan)) {
                return false;
            }
            LocalDateTime this$startTime = this.getStartTime();
            LocalDateTime other$startTime = other.getStartTime();
            return !(this$startTime == null ? other$startTime != null : !((Object)this$startTime).equals(other$startTime));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof DataCollector;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getPageSize();
            Duration $stepSpan = this.getStepSpan();
            result = result * 59 + ($stepSpan == null ? 43 : ((Object)$stepSpan).hashCode());
            LocalDateTime $startTime = this.getStartTime();
            result = result * 59 + ($startTime == null ? 43 : ((Object)$startTime).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "AssemblyProp.DataCollector(pageSize=" + this.getPageSize() + ", stepSpan=" + this.getStepSpan() + ", startTime=" + this.getStartTime() + ")";
        }
    }

    public static class JobProp {
        private Boolean enabled = true;
        @Range(min=1L, max=100L)
        private @Range(min=1L, max=100L) int maxThreads = 5;
        @Min(value=0L)
        private @Min(value=0L) int maxRunJob = 100;
        private Duration timeout = Duration.ofMinutes(30L);

        @Generated
        public JobProp() {
        }

        @Generated
        public Boolean getEnabled() {
            return this.enabled;
        }

        @Generated
        public int getMaxThreads() {
            return this.maxThreads;
        }

        @Generated
        public int getMaxRunJob() {
            return this.maxRunJob;
        }

        @Generated
        public Duration getTimeout() {
            return this.timeout;
        }

        @Generated
        public void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Generated
        public void setMaxThreads(int maxThreads) {
            this.maxThreads = maxThreads;
        }

        @Generated
        public void setMaxRunJob(int maxRunJob) {
            this.maxRunJob = maxRunJob;
        }

        @Generated
        public void setTimeout(Duration timeout) {
            this.timeout = timeout;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof JobProp)) {
                return false;
            }
            JobProp other = (JobProp)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getMaxThreads() != other.getMaxThreads()) {
                return false;
            }
            if (this.getMaxRunJob() != other.getMaxRunJob()) {
                return false;
            }
            Boolean this$enabled = this.getEnabled();
            Boolean other$enabled = other.getEnabled();
            if (this$enabled == null ? other$enabled != null : !((Object)this$enabled).equals(other$enabled)) {
                return false;
            }
            Duration this$timeout = this.getTimeout();
            Duration other$timeout = other.getTimeout();
            return !(this$timeout == null ? other$timeout != null : !((Object)this$timeout).equals(other$timeout));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof JobProp;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getMaxThreads();
            result = result * 59 + this.getMaxRunJob();
            Boolean $enabled = this.getEnabled();
            result = result * 59 + ($enabled == null ? 43 : ((Object)$enabled).hashCode());
            Duration $timeout = this.getTimeout();
            result = result * 59 + ($timeout == null ? 43 : ((Object)$timeout).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "AssemblyProp.JobProp(enabled=" + this.getEnabled() + ", maxThreads=" + this.getMaxThreads() + ", maxRunJob=" + this.getMaxRunJob() + ", timeout=" + this.getTimeout() + ")";
        }
    }

    public static class EnvConfig {
        private String iamDomain;
        private String gmcDomain;

        @Generated
        public EnvConfig() {
        }

        @Generated
        public String getIamDomain() {
            return this.iamDomain;
        }

        @Generated
        public String getGmcDomain() {
            return this.gmcDomain;
        }

        @Generated
        public void setIamDomain(String iamDomain) {
            this.iamDomain = iamDomain;
        }

        @Generated
        public void setGmcDomain(String gmcDomain) {
            this.gmcDomain = gmcDomain;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof EnvConfig)) {
                return false;
            }
            EnvConfig other = (EnvConfig)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$iamDomain = this.getIamDomain();
            String other$iamDomain = other.getIamDomain();
            if (this$iamDomain == null ? other$iamDomain != null : !this$iamDomain.equals(other$iamDomain)) {
                return false;
            }
            String this$gmcDomain = this.getGmcDomain();
            String other$gmcDomain = other.getGmcDomain();
            return !(this$gmcDomain == null ? other$gmcDomain != null : !this$gmcDomain.equals(other$gmcDomain));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof EnvConfig;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $iamDomain = this.getIamDomain();
            result = result * 59 + ($iamDomain == null ? 43 : $iamDomain.hashCode());
            String $gmcDomain = this.getGmcDomain();
            result = result * 59 + ($gmcDomain == null ? 43 : $gmcDomain.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "AssemblyProp.EnvConfig(iamDomain=" + this.getIamDomain() + ", gmcDomain=" + this.getGmcDomain() + ")";
        }
    }
}

