package com.digiwin.athena.service.assembly;

import com.digiwin.athena.bo.assembly.SolutionPlan;
import com.digiwin.athena.dto.PageReqCondition;
import com.digiwin.athena.dto.Pagination;
import com.digiwin.athena.dto.assembly.solution.SolutionPlanDetailDTO;
import com.digiwin.athena.dto.assembly.solution.SolutionPlanListDTO;
import com.digiwin.athena.dto.assembly.solution.SolutionPlanPageQo;
import com.digiwin.athena.dto.assembly.solution.SolutionPlanSaveDTO;

import java.util.Map;
import java.util.Set;

/**
 * 解决方案管理服务接口
 */
public interface DSolutionPlanService {

    Pagination<SolutionPlanListDTO> findList(PageReqCondition<SolutionPlanPageQo> pageReqCondition);

    Map<String, Set<SolutionPlanListDTO>> findListByDesignerId(Iterable<String> designerIdColl);

    SolutionPlan save(SolutionPlanSaveDTO designer);

    void save(SolutionPlan bo);

    void deleteById(String objectId);

    SolutionPlanDetailDTO findDetailById(String objectId);

    SolutionPlan findById(String objectId);

    boolean validateUnique(String code, String name, String excludeObjectId);

    boolean checkIamExists(String code);
}