package com.digiwin.athena.service.assembly.impl;

import cn.hutool.core.util.StrUtil;
import com.digiwin.athena.base.BusinessException;
import com.digiwin.athena.convertor.BaseConverter;
import com.digiwin.athena.dto.assembly.variable.VarTreeNodeDTO;
import com.digiwin.athena.mongodb.domain.other.PresetData;
import com.digiwin.athena.service.assembly.DVariableService;
import com.digiwin.athena.sys.PresetDataServiceV2;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.stream.Collectors;

/**
 * 设计器变量查询服务实现
 */
@Slf4j
@Service
@RequiredArgsConstructor
public class DVariableServiceImpl implements DVariableService {
    public static final String PRESET_DATA_KEY_VAR_TREE = "Assembly_Var_Tree";

    private final PresetDataServiceV2 presetDataServiceV2;

    @Override
    public List<VarTreeNodeDTO> queryVariableTree(List<String> keys) {
        // 获取预设数据
        PresetData presetData = presetDataServiceV2.getPresetDataObject(PRESET_DATA_KEY_VAR_TREE);
        if (presetData == null || StrUtil.isBlank(presetData.getValue())) {
            throw new BusinessException("未找到变量树配置数据！");
        }

        // 反序列化数据到Map
        List<VarTreeNodeDTO> varNodeList = BaseConverter.INSTANCE.deserializeList(
                presetData.getValue(), VarTreeNodeDTO.class);
        if (varNodeList == null || varNodeList.isEmpty()) {
            throw new BusinessException("未找到变量树配置数据！");
        }

        // 如果keys为空，返回全部
        if (keys == null || keys.isEmpty()) {
            return varNodeList;
        }

        // 根据keys过滤
        return varNodeList.stream()
                .filter(entry -> keys.contains(entry.getValue()))
                .collect(Collectors.toList());
    }
}
