package com.digiwin.athena.mongodb.domain;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.actuator.HttpExecuteConfig;
import lombok.Data;

@Data
public class ExecuteConfig {

    private String url;

    private String method = "POST";

    private JSONObject headers;

    private String requestScript;
    private String responseScript;


    public HttpExecuteConfig createHttpExecuteConfig(){
        HttpExecuteConfig httpExecuteConfig = new HttpExecuteConfig();
        httpExecuteConfig.setUrl(url);
        httpExecuteConfig.setMethod(method);
        httpExecuteConfig.setHeaders(headers);
        httpExecuteConfig.setRequestScript(requestScript);
        httpExecuteConfig.setResponseScript(responseScript);

        return httpExecuteConfig;
    }
}
