package com.digiwin.athena.service.impl;

import com.digiwin.athena.dao.mongodao.asset.RAssetDefinitionMongoDao;
import com.digiwin.athena.dao.mongodao.asset.RAssetMongoDao;
import com.digiwin.athena.service.ApplicationDeleteService;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

@Service
@Slf4j
@RequiredArgsConstructor
public class AssetDeleteServiceImpl  implements ApplicationDeleteService {

    private final RAssetMongoDao rAssetMongoDao;
    private final RAssetDefinitionMongoDao rAssetDefinitionMongoDao;

    @Override
    public void applicationDeleteOperation(String appCode) {
        rAssetMongoDao.deleteByApplication(appCode);
        rAssetDefinitionMongoDao.deleteByApplication(appCode);
    }
}
