/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.service.applicationHandler.handler;

import com.digiwin.athena.actuator.HttpActuator;
import com.digiwin.athena.actuator.HttpExecuteConfig;
import com.digiwin.athena.actuator.ReqPlaceholder;
import com.digiwin.athena.bo.assembly.Designer;
import com.digiwin.athena.bo.assembly.SolutionPlan;
import com.digiwin.athena.dto.PageReqCondition;
import com.digiwin.athena.dto.Pagination;
import com.digiwin.athena.dto.ResultDto;
import com.digiwin.athena.dto.assembly.solution.SolutionPlanDetailDTO;
import com.digiwin.athena.dto.asset.AssetCenterInfoResDto;
import com.digiwin.athena.dto.assetType.AssetTypeResDto;
import com.digiwin.athena.enums.DeleteApplicationProcessEnum;
import com.digiwin.athena.mongodb.domain.ApiInfo;
import com.digiwin.athena.mongodb.domain.ExecuteConfig;
import com.digiwin.athena.mongodb.domain.application.Application;
import com.digiwin.athena.service.applicationHandler.handler.AbstractDeletionHandler;
import com.digiwin.athena.service.assembly.RDesignerService;
import com.digiwin.athena.service.assembly.RSolutionPlanService;
import com.digiwin.athena.service.asset.AssetCenter;
import com.digiwin.athena.service.assetType.RAssetTypeService;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class AssetDeleteHandler
extends AbstractDeletionHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AssetDeleteHandler.class);
    private final AssetCenter assetCenter;
    private final HttpActuator httpActuator;
    private final RSolutionPlanService rSolutionPlanService;
    private final RDesignerService rDesignerService;
    private final RAssetTypeService rAssetTypeService;

    protected void doDeleteExecute(Application application) {
        SolutionPlan solutionPlan = this.rSolutionPlanService.findByAppType(application.getAppType());
        if (solutionPlan == null || CollectionUtils.isEmpty(solutionPlan.getDesignerList())) {
            return;
        }
        List<SolutionPlanDetailDTO.DesignerBaseInfoDTO> designerList = solutionPlan.getDesignerList();
        Set<String> designerIds = designerList.stream().map(d -> d.getId()).collect(Collectors.toSet());
        List<Designer> designerDetailDTOS = this.rDesignerService.getDesigners(designerIds);
        Set<String> assetTypeIds = designerDetailDTOS.stream().filter(d -> d.getRelatedAssetType() != null && !CollectionUtils.isEmpty(d.getRelatedAssetType().getWrite())).map(d -> d.getRelatedAssetType().getWrite()).flatMap(Collection::stream).map(a -> a.getObjId()).collect(Collectors.toSet());
        List<AssetTypeResDto> assetTypes = this.rAssetTypeService.getAssetTypes(assetTypeIds);
        ObjectMapper mapper = new ObjectMapper();
        for (AssetTypeResDto assetType : assetTypes) {
            List apiInfos = Stream.of(assetType.getOpenApiList(), assetType.getApiList()).filter(Objects::nonNull).flatMap(Collection::stream).filter(a -> a.getKey().equals("appDelete") && a.getExecuteConfig() != null).collect(Collectors.toList());
            if (apiInfos.isEmpty()) continue;
            PageReqCondition pageReqCondition = new PageReqCondition();
            pageReqCondition.setPageSize(Integer.valueOf(100));
            Pagination<AssetCenterInfoResDto> pagination = this.assetCenter.appAssetList((PageReqCondition<String>)pageReqCondition, List.of(application.getCode()), List.of(assetType.getType()));
            List datas = pagination.getData();
            while (!CollectionUtils.isEmpty((Collection)datas)) {
                for (ApiInfo apiInfo : apiInfos) {
                    List requestParams;
                    ExecuteConfig executeConfig = apiInfo.getExecuteConfig();
                    HttpExecuteConfig httpExecuteConfig = executeConfig.createHttpExecuteConfig();
                    ResultDto res = (ResultDto)this.httpActuator.execute(httpExecuteConfig, (Object)(requestParams = (List)mapper.convertValue((Object)datas, (TypeReference)new TypeReference<List<Map<String, Object>>>(){})), ReqPlaceholder.createParams(null), ResultDto.class);
                    if (res.getCode() == 0) continue;
                    try {
                        log.error("\u5220\u9664\u8d44\u4ea7\u6570\u636e\u5f02\u5e38:" + mapper.writeValueAsString((Object)res));
                    }
                    catch (JsonProcessingException e) {
                        throw new RuntimeException(e);
                    }
                    throw new RuntimeException("\u5220\u9664\u8d44\u4ea7\u6570\u636e\u5f02\u5e38");
                }
                pageReqCondition.setPageNum(Integer.valueOf(pageReqCondition.getPageNum() + 1));
                pagination = this.assetCenter.appAssetList((PageReqCondition<String>)pageReqCondition, List.of(application.getCode()), List.of(assetType.getType()));
                datas = pagination.getData();
            }
        }
    }

    protected void doValidateExecute(Application application) {
    }

    protected void doBackup(Application application) {
    }

    DeleteApplicationProcessEnum getDeleteType() {
        return DeleteApplicationProcessEnum.DELETE_ASSET;
    }

    @Generated
    public AssetDeleteHandler(AssetCenter assetCenter, HttpActuator httpActuator, RSolutionPlanService rSolutionPlanService, RDesignerService rDesignerService, RAssetTypeService rAssetTypeService) {
        this.assetCenter = assetCenter;
        this.httpActuator = httpActuator;
        this.rSolutionPlanService = rSolutionPlanService;
        this.rDesignerService = rDesignerService;
        this.rAssetTypeService = rAssetTypeService;
    }
}

