package com.digiwin.athena.controller.assembly;

import com.digiwin.athena.bo.assembly.RuntimeVariable;
import com.digiwin.athena.dto.ResultDto;
import com.digiwin.athena.service.assembly.RVariableService;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 变量运行时
 */
@Slf4j
@RestController
@RequestMapping("/assembly/variable/r/")
@RequiredArgsConstructor
@Validated
public class RVariableController {

    private final RVariableService rVariableService;

    /**
     * 运行时变量查询
     */
    @GetMapping("get")
    public ResultDto<RuntimeVariable> queryRuntimeVariable() {
        RuntimeVariable result = rVariableService.getRuntimeVar();
        return ResultDto.createSuccess(result);
    }
}
